fprintf(2, '\n** Sending a blocking request for "dstevr"\n\n')
clear
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dstevr','V','A',D,E,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVR(V,A) Failure **')
    rr
  else
    fprintf(2, '** DSTEVR(V,A) Passed Tests **\n')
  end
end

clear
N=20;
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
DU1=diag(C1,+1);
C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
A=C+C';
D=diag(A);
E1=diag(A,-1);
for i=1:N-1
  E2(i)=E1(i);
end
  E2(N)=0;
E=E2';
vl=2.0;
vu=5.0;
il=1;
iu=N;
abstol=2*eps;
[m,W,Z,isuppz,info]=netsolve('dstevr','V','V',D,E,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
      r2(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
  end
  rr=max(r2);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DSTEVR(V,V) Failure **')
    rr
  else
    fprintf(2, '** DSTEVR(V,V) Passed Tests **\n')
  end
end

% RANGE='I' is not yet supported in DSTEGR
%
%clear
%N=20;
%C1=rand(20);
%DL1=diag(C1,-1);
%D1=diag(C1);
%DU1=diag(C1,+1);
%C=diag(D1)+diag(DL1,-1)+diag(DU1,1);
%A=C+C';
%D=diag(A);
%E1=diag(A,-1);
%for i=1:N-1
%  E2(i)=E1(i);
%end
%  E2(N)=0;
%E=E2';
%vl=2.0;
%vu=5.0;
%il=1;
%iu=N;
%abstol=2*eps;
%[m,W,Z,isuppz,info]=netsolve('dstevr','V','I',D,E,vl,vu,il,iu,abstol);
%for k=1:m
%    r3(k)=norm(A*Z(:,k)-W(k)*Z(:,k))/(norm(A)*norm(Z(:,k))*m*eps);
%end
%rr=max(r3);
%[e] = netsolve_err;
%
%if (e ~= 0 | info ~= 0 | rr > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DSTEVR(V,I) Failure **')
%  rr
%else
%  fprintf(2, '** DSTEVR(V,I) Passed Tests **\n')
%end

