fprintf(2, '\n** Sending a blocking request for "dsbgvx"\n\n')
clear N C1 C KA AB1 A C3 KU KL C4 B KB BB1 W Z info
N=20;
%Get band stored matrix A, upper triangle part of A,B is stored.
C1=rand(N);
C=C1+C1';
KA=4;
AB1=zeros(KA+1,N);
for i=1:N
  for j=max(1,i-KA):min(N,i+KA)
        A(i,j)=C(i,j);
  end
end
for j=1:N
  for i=max(1,j-KA):j
        AB1(KA+1+i-j,j)=A(i,j);
  end
end
%Get band stored matrix B.
C4=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C4(i,j)=C4(i,j)*100;
      end
  end
end
B=C4*C4';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=max(1,j-KB):j
        BB1(KB+1+i-j,j)=B(i,j);
  end
end
vl=1.0;
vu=5.0;
il=1;
iu=N;
abstol=0.01*eps;
[AB1,BB1,Q,m,W,Z,ifail,info]=netsolve('dsbgvx','V','A','U',KA,KB,AB1,BB1,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGVX(UPLO=U) Failure **\n')
    r
  else
    fprintf(2, '** DSBGVX(UPLO=U) Passed Tests **\n')
  end
end

clear C1 B KB BB1 Q m W Z ifail info
%Get band stored matrix B.
C1=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C1(i,j)=C1(i,j)*100;
      end
  end
end
B=C1*C1';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=j:min(N,j+KB)
        BB1(1+i-j,j)=B(i,j);
  end
end
vl=1.0;
vu=2.0;
il=1;
iu=N;
abstol=0.01*eps;
[AB1,BB1,Q,m,W,Z,ifail,info]=netsolve('dsbgvx','V','A','L',KA,KB,AB1,BB1,vl,vu,il,iu,abstol);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:m
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGVX(UPLO=L) Failure ** \n')
    fprintf(2,'dsbgvx info = %d\n',info)
    r
  else
    fprintf(2, '** DSBGVX(UPLO=L) Passed Tests **\n')
  end
end
