fprintf(2, '\n** Sending a blocking request for "dsbgv"\n\n')
clear N C1 C KA AB1 A C3 KU KL C4 B KB BB1 W Z info
N=20;
%Get band stored matrix A, upper triangle part of A,B is stored.
C1=rand(N);
C=C1+C1';
KA=4;
AB1=zeros(KA+1,N);
for i=1:N
  for j=max(1,i-KA):min(N,i+KA)
        A(i,j)=C(i,j);
  end
end
for j=1:N
  for i=max(1,j-KA):j
        AB1(KA+1+i-j,j)=A(i,j);
  end
end
%Get band stored matrix B.
C4=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C4(i,j)=C4(i,j)*100;
      end
  end
end
B=C4*C4';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=max(1,j-KB):j
        BB1(KB+1+i-j,j)=B(i,j);
  end
end
[AB1,BB1,W,Z,info]=netsolve('dsbgv','V','U',KA,KB,AB1,BB1);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGV(UPLO=U) Failure **\n')
    r
  else
    fprintf(2, '** DSBGV(UPLO=U) Passed Tests **\n')
  end
end

%Get band stored matrix B.
C1=rand(N);
for i=1:N
  for j=1:N
      if (i==j) C1(i,j)=C1(i,j)*100;
      end
  end
end
B=C1*C1';
KB=4;
BB1=zeros(KB+1,N);
for j=1:N
  for i=j:min(N,j+KB)
        BB1(1+i-j,j)=B(i,j);
  end
end

[AB1,BB1,W,Z,info]=netsolve('dsbgv','V','L',KA,KB,AB1,BB1);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
    r1(k)=(norm(A*Z(:,k)-W(k)*B*Z(:,k)))/(norm(A)*norm(B)*norm(Z(:,k)));
  end
  r=max(r1);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DSBGV(UPLO=L) Failure ** \n')
    r
  else
    fprintf(2, '** DSBGV(UPLO=L) Passed Tests **\n')
  end
end
