fprintf(2, '\n** Sending a blocking request for "dptsv"\n\n')
clear
B=rand(20,5);
C1=rand(20);
DL1=diag(C1,-1);
D1=diag(C1);
%DU1=diag(C1,+1);
C2=diag(D1)+diag(DL1,-1);
A=C2*C2';
D=diag(A);
E=diag(A,-1);
[D,E,X,info]=netsolve('dptsv',D,E,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r=norm(A*X-B)/(norm(A)*norm(X)*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DPTSV Failure **')
    r
  else
    fprintf(2, '** DPTSV Passed Tests **\n')
  end
end
