fprintf(2, '\n** Sending a blocking request for "dpbsv"\n\n')
clear
C1=rand(20);
KU=4;
KL=3;
B=rand(20,5);
for i=1:20
  for j=max(1,i-KL):min(20,i+KU)
        C2(i,j)=C1(i,j);
  end
end
A=C2*C2';
KD=KU+KL;
for j=1:20
  for i=max(1,j-KD):j
        AB1(KD+1+i-j,j)=A(i,j);
  end
end
[AB1,X,info]=netsolve('dpbsv','U',KD,AB1,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r1=norm(A*X-B)/(norm(A)*norm(X)*20*eps);
  if ( info ~= 0 | r1 > 50.0 )
    fprintf(2, '** DPBSV(U) Failure **')
    r1
  else
    fprintf(2, '** DPBSV(U) Passed Tests **\n')
  end
end


for j=1:20
  for i=j:min(20,j+KD)
        AB2(1+i-j,j)=A(i,j);
  end
end
[AB2,X,info]=netsolve('dpbsv','L',KD,AB2,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r2=norm(A*X-B)/(norm(A)*norm(X)*20*eps);
  if (info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DPBSV(L) Failure **')
    r2
  else
    fprintf(2, '** DPBSV(L) Passed Tests **\n')
  end
end
