fprintf(2, '\n** Sending a blocking request for "dggev"\n\n')
clear
N=20;
A=rand(N);
B=rand(N);
[ALPHAR,ALPHAI,BETA,VL,VR,info]=netsolve('dggev','V','V',A,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  for k=1:N
    r1(k)=(norm(BETA(k)*A*VR(:,k)-(ALPHAR(k)+j*ALPHAI(k))*B*VR(:,k)))/(norm(A)*norm(B)*norm(VR(:,k)));
  end
  rr1=max(r1);

  for k=1:N
    r2(k)=norm(BETA(k)*conj(VL(:,k)')*A-(ALPHAR(k)+j*ALPHAI(k))*conj(VL(:,k)')*B)/(norm(A)*norm(B)*norm(VL(:,k)));
  end
  rr2=max(r2);
  if (info ~= 0 | rr1 > 50.0 | rr2 > 50.0 )
    fprintf(2, '** DGGEV(V,V) Failure **')
    rr1
    rr2
  else
    fprintf(2, '** DGGEV(V,V) Passed Tests **\n')
  end
end
