fprintf(2, '\n** Sending a blocking request for "dgesvd"\n\n')
clear
M=25;
N=20;
A=rand(M,N);
[B,S,U,VT,info]=netsolve('dgesvd','A','A',A);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  V=VT';
  for i=1:N
    r(i)=norm(A*V(:,i)-S(i)*U(:,i))/(norm(A)*norm(V(:,i))*norm(U(:,i))*N*eps);
  end
  rr=max(r);
  if ( info ~= 0 | rr > 50.0 )
    fprintf(2, '** DGESVD Failure **')
    rr
  else
    fprintf(2, '** DGESVD Passed Tests **\n')
  end
end
