fprintf(2, '\n** Sending a blocking request for "dgesv"\n\n')
clear
n = 20;
a = rand(n);
b = rand(n,2);
[x,y,z,info]=netsolve('dgesv',a,b);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r=norm(a*z-b)/(norm(a)*norm(z)*n*eps);
  if ( info~= 0 | r > 50.0 )
    fprintf(2, '** DGESV Failure **')
    r
  else
    fprintf(2, '** DGESV Passed Tests **\n')
  end
end
