fprintf(2, '\n** Sending a blocking request for "dgelsy"\n\n')
%clear M N NRHS A B JPVT RCOND AA X RANK INFO r1
%M=25;
%N=20;
%NRHS=5;
%A=rand(M,N);
%if M>=N
%B=rand(M,NRHS);
%else
%B=rand(N,NRHS);
%end
%JPVT=zeros(N,1);
%RCOND=sqrt(eps)-(sqrt(eps)-eps)/2;
%
%[AA,X,JPVT,RANK,INFO]=netsolve('dgelsy',A,B,JPVT,RCOND);
%r1 = norm(A*X-B)/(norm(A)*norm(X)*M*eps);
%[e] = netsolve_err;
%count = count + 1;
%
%if (e ~= 0 | info ~= 0 | r1 > 50.0 )
%  fprintf(2,'%s\n',netsolve_errmsg(e))
%  fprintf(2, '** DGELSY(M>N) Failure **')
%  r1
%  failcount = failcount + 1;
%end

clear
M=20;
N=20;
NRHS=5;
A=rand(M,N);
if M>=N
B=rand(M,NRHS);
else
B=rand(N,NRHS);
end
JPVT=zeros(N,1);
RCOND=sqrt(eps)-(sqrt(eps)-eps)/2;

[AA,X,JPVT,RANK,info]=netsolve('dgelsy',A,B,JPVT,RCOND);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r2 = norm(A*X-B)/(norm(A)*norm(X)*N*eps);
  if ( info ~= 0 | r2 > 50.0 )
    fprintf(2, '** DGELSY(M=N) Failure **')
    r2
  else
    fprintf(2, '** DGELSY(M=N) Passed Tests **\n')
  end
end
