fprintf(2, '\n** Sending a blocking request for "dgbsv"\n\n')
clear
C=rand(20);
ku=8;
kl=6;
B=rand(20,5);
for i=1:20
  for j=max(1,i-kl):min(20,i+ku)
        A(i,j)=C(i,j);
  end
end
for j=1:20
  for i=max(1,j-ku):min(20,j+kl)
        Ab(kl+ku+1+i-j,j)=A(i,j);
  end
end
[Ab,IPIV,X,info]=netsolve('dgbsv',kl,ku,Ab,B);
[e] = netsolve_err;
if (e ~= 0)
  fprintf(2,'%s\n',netsolve_errmsg(e))
else
  r=norm(A*X-B)/(norm(A)*norm(X)*20*eps);
  if ( info ~= 0 | r > 50.0 )
    fprintf(2, '** DGBSV Failure **')
    r
  else
    fprintf(2, '** DGBSV Passed Tests **\n')
  end
end
