
(****************** NSlapacktest.m *********************)

NSTestPause[] := Module[{s},
   s = InputString["Type 'q' to exit from this test or hit Enter to continue: "];
   Return[s == "q"]
]

NSnorm[V_]:= Module[{},
   If[(MatrixQ[V]||VectorQ[V]),Return[Max[SingularValues[V][[2]]]],NULL];
   
] 



(* ************* dgesv *************** *)

NSTestdgesv[]:= Module[{},
Print["-----------------------------------------"];
Print["** Sending a blocking request for "dgesv""];
Print["-----------------------------------------\n"];
TheCount=0;
FailCount=0;
n=20;
a=Table[Random[],{xx,n},{yy,n}];
b=Table[Random[],{xx,n},{yy,2}];
{x,y,z,info}=NetSolve[dgesv[a,b]];
R=NSnorm[a.z-b]/(NSnorm[a]*NSnorm[z]*n*$MachineEpsilon);
Err = netsolve_err;
TheCount = TheCount+1;
Print["info = ", info];
Print["R = ",R];
  If[(Err!=0||INFO!=0||R>50.0),
      Print[netsolve_errmsg(Err)];Print["\n** DGESV Failure **\n"]; FailCount=FailCount+1, NULL];
Return[NSTestPause[]]
     ]    

(* ************* dgesv non-blocking *************** *)

NSTestdgesvNB[]:= Module[{},
Print["--------------------------------------------"];
Print["** Sending a non-blocking request for "dgesv""];
Print["--------------------------------------------\n"];
n=20;
a=Table[Random[],{xx,n},{yy,n}];
b=Table[Random[],{xx,n},{yy,2}];
Print["Requesting.....\n"];
request=NetSolveNB[dgesv[a,b]];
Print["request =",request];
Print["\n Try NetSolveProbe[request] now\n"];
Print["The result is:",NetSolveProbe[request]];
Print["Block and wait for the result...\n"];
{x,y,z,info}=NetSolveWait[request];
R=NSnorm[a.z-b]/(NSnorm[a]*NSnorm[z]*n*$MachineEpsilon);
Err = netsolve_err;
TheCount = TheCount+1;
Print["info = ", info];
Print["R = ",R];
  If[(Err!=0||INFO!=0||R>50.0),
      Print[netsolve_errmsg(Err)];Print["\n** DGESV Failure **\n"]; FailCount=FailCount+
1, NULL];
Return[NSTestPause[]]
     ]   



(* ************** dgbsv ****************** *)

 NSTestdgbsv[]:= Module[{},
Print["-----------------------------------------"];
Print["** Sending a blocking request for "dgbsv""];
Print["-----------------------------------------\n"];
ClearAll[ku,kl,B,A,C1,Ab,IPIV,X,info,r,xx,yy];
C1=Table[Random[],{xx,20},{yy,20}];
ku=8;
kl=6;
B=Table[Random[],{xx,20},{yy,5}];
A1=Table[0,{20},{20}];
For[i=1,i<21,i++,
     For[j=Max[1,i-kl],j<Min[20,i+ku]+1,j++,
         A1[[i,j]]=C1[[i,j]]
        ];
   ];
    
Ab=Table[0,{21},{20}];
For[j=1,j<21,j++,
     For[i=Max[1,j-ku],i<Min[20,j+kl]+1,i++,
         Ab[[kl+ku+1+i-j,j]]=A1[[i,j]]
        ];
   ];


{Ab,IPIV,X,info}=NetSolve[dgbsv[kl,ku,Ab,B]];
R=NSnorm[A1.X-B]/(NSnorm[A1]*NSnorm[X]*20*$MachineEpsilon);
Err = netsolve_err;
TheCount = TheCount+1;
Print["info = ", info];
Print["R = ",R];
If[(Err!=0||info!=0||R>50.0),
      Print[netsolve_errmsg(Err)];Print["\n** DGBSV Failure **\n"]; FailCount=FailCount+1, NULL];

Return[NSTestPause[]]
]



(* ************** dgbsv non-blocking****************** *)

 NSTestdgbsvNB[]:= Module[{},
Print["--------------------------------------------"];
Print["** Sending a non-blocking request for "dgbsv""];
Print["--------------------------------------------\n"];
ClearAll[ku,kl,B,A,C1,Ab,IPIV,X,info,r,xx,yy];
C1=Table[Random[],{xx,20},{yy,20}];
ku=8;
kl=6;
B=Table[Random[],{xx,20},{yy,5}];
A1=Table[0,{20},{20}];
For[i=1,i<21,i++,
     For[j=Max[1,i-kl],j<Min[20,i+ku]+1,j++,
         A1[[i,j]]=C1[[i,j]]
        ];
   ];

Ab=Table[0,{21},{20}];
For[j=1,j<21,j++,
     For[i=Max[1,j-ku],i<Min[20,j+kl]+1,i++,
         Ab[[kl+ku+1+i-j,j]]=A1[[i,j]]
        ];
   ];
Print["Requesting.....\n"];
request=NetSolveNB[dgbsv[kl,ku,Ab,B]];
Print["request =",request];
Print["\n Try NetSolveProbe[request] now\n"];
Print["The result is:",NetSolveProbe[request]];
Print["Block and wait for the result...\n"];
{Ab,IPIV,X,info}=NetSolveWait[request];
R=NSnorm[A1.X-B]/(NSnorm[A1]*NSnorm[X]*20*$MachineEpsilon);
Err = netsolve_err;
TheCount = TheCount+1;
Print["info = ", info];
Print["R = ",R];
If[(Err!=0||info!=0||R>50.0),
      Print[netsolve_errmsg(Err)];Print["\n** DGBSV Failure **\n"]; FailCount=FailCount+
1, NULL];

Return[NSTestPause[]]
]


(* *************** dposv *************** *)
NSTestdposv := Module[{},
Print["-----------------------------------------"];
Print["** Sending a blocking request for "dposv""];
Print["-----------------------------------------\n"];
ClearAll[B,C1,A,n,A1,X,info,Err,R,xx,yy];
n=20;
B=Table[Random[],{xx,n},{yy,5}];
C1=Table[Random[],{xx,n},{yy,n}];
A=C1.Transpose[C1];
Print["...............DPOSV(U).................."];
{A1,X,info}=NetSolve[dposv["U",A,B]];
R1=NSnorm[A.X-B]/(NSnorm[A]*NSnorm[X]*n*$MachineEpsilon);
Err = netsolve_err;
TheCount = TheCount+1;
Print["info = ", info];
Print["R1 = ",R1];
If[(Err!=0||info!=0||R1>50.0),
      Print[netsolve_errmsg(Err)];Print["\n** DPOSV(U) Failure **\n"]; FailCount=FailCount+
1, NULL];

Print["...............DPOSV(L).................."];
{A1,X,info}=NetSolve[dposv["L",A,B]];
R2=NSnorm[A.X-B]/(NSnorm[A]*NSnorm[X]*n*$MachineEpsilon);
Err = netsolve_err;
Print["info = ", info];
Print["R2 = ",R2];
TheCount = TheCount+1;
If[(Err!=0||info!=0||R2>50.0),
      Print[netsolve_errmsg(Err)];Print["\n** DPOSV(L) Failure **\n"]; FailCount=FailCount+1,NULL];


Return[NSTestPause[]]
]


(* *************** dposv *************** *)
NSTestdposvNB := Module[{},
Print["--------------------------------------------"];
Print["** Sending a non-blocking request for "dposv""];
Print["--------------------------------------------\n"];
ClearAll[B,C1,A,n,A1,X,info,Err,R,xx,yy];
n=20;
B=Table[Random[],{xx,n},{yy,5}];
C1=Table[Random[],{xx,n},{yy,n}];
A=C1.Transpose[C1];
Print["...............DPOSV(U).................."];
Print["Requesting......\n"];
request=NetSolveNB[dposv["U",A,B]];
Print["request =",request];
Print["\n Try NetSolveProbe[request] now\n"];
Print["The result is:",NetSolveProbe[request]];
Print["Block and wait for the result...\n"];
{A1,X,info}=NetSolveWait[request];
R1=NSnorm[A.X-B]/(NSnorm[A]*NSnorm[X]*n*$MachineEpsilon);
Err = netsolve_err;
TheCount = TheCount+1;
Print["info = ", info];
Print["R1 = ",R1];
If[(Err!=0||info!=0||R1>50.0),
  Print[netsolve_errmsg(Err)];Print["\n** DPOSV(U) Failure **\n"]; FailCount=FailCount+ 1, NULL];
Print["...............DPOSV(L).................."];
Print["Requesting......\n"];
request=NetSolveNB[dposv["L",A,B]];
Print["request =",request];
Print["\n Try NetSolveProbe[request] now\n"];
Print["The result is:",NetSolveProbe[request]];
Print["Block and wait for the result...\n"];
{A1,X,info}=NetSolveWait[request];
R2=NSnorm[A.X-B]/(NSnorm[A]*NSnorm[X]*n*$MachineEpsilon);
Err = netsolve_err;
Print["info = ", info];
Print["R2 = ",R2];
TheCount = TheCount+1;
If[(Err!=0||info!=0||R2>50.0),
   Print[netsolve_errmsg(Err)];Print["\n** DPOSV(L) Failure **\n"]; FailCount=FailCount+1,NULL];

Return[NSTestPause[]]
]





NSTestLapack[] := Module[{},
   Print["\nThis test file written in Mathematica test"] ;
   Print["the NetSolve Mathematica Lapack interface."];
  If[ StringQ[NetSolveGetAgent[] == False ],
       (Print["NetSolve is not installed. Please follow the debscribed"];
       Print["above procedure and run the test again"];
       Return[]),
       If[ NetSolveGetAgent[] == "",
           (Print["You have not setup an agent. Please run NetSolveSetAgent"];
            Print["to set up your agent and run this demo again.\n"];
            Return[]),
           Null
         ]
     ];

   Print["Now you are ready to run the test.\n"]; 
   Print["------------------------------------------------------"];
   Print["Testing the NetSolve MATHEMATICA LAPACK  interfaces..."];
   Print["------------------------------------------------------"];
   



   If[NSTestdgesv[],Return[],Null];  
   If[NSTestdgesvNB[],Return[],Null];
   If[NSTestdgbsv[],Return[],Null]; 
   If[NSTestdgbsvNB[],Return[],Null]; 
   If[NSTestdposv[],Return[],Null]; 
   If[NSTestdposvNB[],Return[],Null]; 
   
   
   Print["\n**",TheCount," Tests were performed.\n"];
   Print["\n**",FailCount," Tests failed to pass the threshold.\n\n"];

   
   Print["--------------------"];
   Print["** End of testing **"];
   Print["--------------------\n\n"]; 
   Pause[1];

]

NSTestLapack[]
ClearAll["NSTest*"]
