/*****************************************************************/
/*      farmtest.c                                               */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "netsolve.h"
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
 
double win_drand48(){
	return ((double)rand()/32767.0);
}

int main(int argc,char **argv)
{
  char dummy;
  int i,n; 
  int *status;
  char buf[128];
  double **a;
  double *tmp;
  int ok;
  
  if (argc != 2)
  {
    fprintf(stderr,"Usage: %s <nb requests>\n",argv[0]);
    exit(-1);
  }

  srand((unsigned)time(NULL));

  fprintf(stderr,"Testing the Farming feature...\n");
  n = atoi(argv[1]);

  fprintf(stderr,"Input Data Generated.\n");
  a = (double **)calloc(n,sizeof(double*));
  tmp = (double *)calloc(n,sizeof(double));
  for (i=0;i<n;i++)
  {
    a[i] = (double *)calloc(1,sizeof(double));
    *(a[i]) =((double)n)*win_drand48();
    tmp[i] = *(a[i]);
  }

  fprintf(stderr,"\nPress <enter> to continue\n");
  scanf("%c",&dummy);

  sprintf(buf,"i=0,%d",n-1);
  status = netsl_farm(buf,"doubletest()",ns_ptr_array((void**)a,"$i"));
  if (status[0] == -1)
  {
    for (i=0;i<n;i++){
    fprintf(stderr,"requests #%d: %s\n",
            i,netsolveErrorMessage(status[i+1]));
    }
    fprintf(stderr, "\n%75s\n", "Result: Failure");
    exit(-1);
  }
  else
  {
    ok = 1;
    for (i=0;i<n;i++)
    {
      double dif = tmp[i]+1.0 - *a[i];
      if ( 1E-6 < fabs(dif) )
      {
        fprintf(stderr,"%g ---> %g (dif %f)\n", tmp[i], *a[i], dif);
        fprintf(stderr,"%x ---> %x\n",(unsigned)&tmp[i],(unsigned)(a[i]));
        ok = 0;
      }
    }
    if (!ok){
      fprintf(stderr,"Incorrect output result\n");
      fprintf(stderr, "\n%75s\n", "Result: Failure");
      exit(-1);
    }
    else
      fprintf(stderr, "\n%75s\n", "Result: Success");
  }
  free(status);

  exit(0);
}
