
      PROGRAM EXAMPLE


      INTEGER SYNC,ASYNC

      EXTERNAL intTest,stringTest,isortTest,dsortTest
      EXTERNAL totalTest,upfTest

      SYNC = 0
      ASYNC = 1

      WRITE(*,*) 'NetSolve Fortran Interface Test Suite'
      WRITE(*,*) '-------------------------------'
      WRITE(*,*) 'This test suite performs 5 tests, in both synchronous'
      WRITE(*,*) 'and asynchronous modes.'
      WRITE(*,*) 'In the asynchronous mode, a dot (.) is printed every'
      WRITE(*,*) 'second to illustrate the fact that this program is '
      WRITE(*,*) 'not blocked but waiting for the request to complete.'
      WRITE(*,*) 'This might not be observable as tests are short'
      WRITE(*,*) 'and some (e.g. upf test) induce client overhead.'
      WRITE(*,*) 'Press <enter> to start the testing...'

      READ(*,*)

      CALL intTest(SYNC)
      CALL intTest(ASYNC)
      CALL isortTest(SYNC)
      CALL isortTest(ASYNC)
      CALL dsortTest(SYNC)
      CALL dsortTest(ASYNC)
      CALL totalTest(SYNC)
      CALL totalTest(ASYNC)
C      CALL stringTest(ASYNC)
C      CALL stringTest(ASYNC)
      CALL upfTest(SYNC)
      CALL upfTest(ASYNC)

      STOP
      END


C
C intTest()
C
      SUBROUTINE intTest(mode)
      INCLUDE '../../include/fnetsolve.h'
      INTEGER mode
      INTEGER i, ii, iii, status
      INTEGER request
      EXTERNAL fnetsl, fnetslnb, fnetslerr, fnetslpr, fnetslwt

      i = 3

      WRITE(*,'(A,$)') '** integer test ('
      IF (mode.EQ.0) THEN
        WRITE(*,*) 'synchronous) **'
      ELSE
        WRITE(*,*) 'asynchronous) **'
      ENDIF

      IF (mode.EQ.0) THEN
        CALL fnetsl('inttest()',status,i)
        WRITE(*,*) ' '
      ELSE
        CALL fnetslnb('inttest()',status,i)
      ENDIF
    
      IF (status.LT.0) THEN
        CALL FNETSLERR(status)
        WRITE(*,'(A75)') 'Result: Failure'
        RETURN
      ENDIF

      IF (mode.EQ.1) THEN
        request = status
        IF (request.GE.0) THEN
          CALL fnetslpr(request,status)
          WRITE(*,'(A,$)') '...'
10        CONTINUE
          IF (status.NE.NetSolveNotReady) THEN
            GOTO 20
          ENDIF
          DO 15 ii=1,500
             iii = ii + 3*ii
15        CONTINUE
C         WRITE(*,'(A,$)') '.'
          CALL fnetslpr(request,status)
          GOTO 10
20        WRITE(*,*) ' '
          IF (status.EQ.NetSolveOK) THEN
            CALL fnetslwt(request,status)
          ENDIF
        ENDIF
      ENDIF

      IF (status.NE.NetSolveOK) THEN
        CALL fnetslerr(status)
        WRITE(*,'(A75)') 'Result: Failure'
      ELSE
        IF (i.NE.4) THEN
          WRITE(*,*) 'Returned ',i,' instead of 4'
          WRITE(*,'(A75)') 'Result: Failure'
        ELSE
          WRITE(*,'(A75)') 'Result: Success'
        ENDIF
      ENDIF

      RETURN
      END

C
C stringTest()
C
      SUBROUTINE stringTest(mode)
      INCLUDE '../../include/fnetsolve.h'
      INTEGER mode
      CHARACTER string(2)
      INTEGER ii, iii, request, status
      EXTERNAL fnetsl, fnetslnb, fnetslerr, fnetslpr, fnetslwt
  
      string(1) = 'a'
      string(2) = 'a'

      WRITE(*,'(A,$)') '** string test ('
      IF (mode.EQ.0) THEN
        WRITE(*,*) 'synchronous)  **'
      ELSE
        WRITE(*,*) 'asynchronous) **'
      ENDIF
    
      IF (mode .EQ. 0) THEN
        CALL fnetsl('stringtest()',status,string)
      ELSE
        CALL fnetslnb('stringtest()',status,string)
      ENDIF

      IF (status.LT.0) THEN
        CALL FNETSLERR(status)
        WRITE(*,'(A75)') 'Result: Failure'
        RETURN
      ENDIF

    
      IF (mode.EQ.1) THEN
        request = status
        IF (request.GE.0) THEN
          CALL fnetslpr(request,status)
          WRITE(*,'(A,$)') '...'
30        CONTINUE
          IF (status.NE.NetSolveNotReady) THEN
            GOTO 40
          ENDIF
          DO 15 ii=1,500
             iii = ii + 3*ii
15        CONTINUE
C         WRITE(*,'(A,$)') '.'
          CALL fnetslpr(request,status)
          GOTO 30
40        WRITE(*,*) ' '
          IF (status.EQ.NetSolveOK) THEN
            CALL fnetslwt(request,status)
          ENDIF
        ENDIF
      ENDIF

      IF (status.NE.NetSolveOK) THEN
        CALL fnetslerr(status)
        WRITE(*,'(A75)') 'Result: Failure'
      ELSE
        IF (string(1).NE.'X')THEN
          WRITE(*,*) 'Returned "',string,'" instead of "Xa"'
          WRITE(*,'(A75)') 'Result: Failure'
        ELSE
          WRITE(*,'(A75)') 'Result: Success'
        ENDIF
      ENDIF

      RETURN
      END
    
C
C isortTest()
C
      SUBROUTINE isortTest(mode)
      INCLUDE '../../include/fnetsolve.h'
      INTEGER MODE
      INTEGER tosort(4)
      INTEGER sorted(4)
      INTEGER ii, iii, request, status 
      EXTERNAL fnetsl, fnetslnb, fnetslerr, fnetslpr, fnetslwt
    
      tosort(1)=4
      tosort(2)=3
      tosort(3)=2
      tosort(4)=1
    
      WRITE(*,'(A,$)') '** integer sort ('
      IF (mode.EQ.0) THEN
        WRITE(*,*) 'synchronous)  **'
      ELSE
        WRITE(*,*) 'asynchronous) **'
      ENDIF
    
      IF (mode.EQ.0) THEN
        CALL fnetsl('iqsort()',status,4,tosort,sorted)
      ELSE
        CALL fnetslnb('iqsort()',status,4,tosort,sorted)
      ENDIF

      IF (status.LT.0) THEN
        CALL FNETSLERR(status)
        WRITE(*,'(A75)') 'Result: Failure'
        RETURN
      ENDIF

    
      IF (mode.EQ.1) THEN
        request = status
        IF (request.GE.0) THEN
          CALL fnetslpr(request,status)
          WRITE(*,'(A,$)') '...'
50        CONTINUE
          IF (status.NE.NetSolveNotReady) THEN
            GOTO 60
          ENDIF
          DO 15 ii=1,500
             iii = ii + 3*ii
15        CONTINUE
C         WRITE(*,'(A,$)') '.'
          CALL fnetslpr(request,status)
          GOTO 50
60        WRITE(*,*) ' '
          IF (status.EQ.NetSolveOK) THEN
            CALL fnetslwt(request,status)
          ENDIF
        ENDIF
      ENDIF


      IF (status .NE. NetSolveOK) THEN
        CALL fnetslerr(status)
        WRITE(*,'(A75)') 'Result: Failure'
      ELSE  
        IF ((sorted(1).NE.1).OR.(sorted(2).NE.2).OR.
     $      (sorted(3).NE.3).OR.(sorted(4).NE.4)) THEN
          WRITE(*,*) 'Array not correctly sorted : ',sorted(1),
     $               sorted(2),sorted(3),sorted(4)
          WRITE(*,'(A75)') 'Result: Failure'
        ELSE
          WRITE(*,'(A75)') 'Result: Success'
        ENDIF
      ENDIF
      
      RETURN
      END
    
C
C dsortTest()
C
      SUBROUTINE dsortTest(mode)
      INCLUDE '../../include/fnetsolve.h'
      INTEGER MODE
      DOUBLE PRECISION tosort(4)
      DOUBLE PRECISION sorted(4)
      INTEGER ii, iii, request, status
      EXTERNAL fnetsl, fnetslnb, fnetslerr, fnetslpr, fnetslwt

      tosort(1)=4.D0
      tosort(2)=3.D0
      tosort(3)=2.D0
      tosort(4)=1.D0

      WRITE(*,'(A,$)') '** double precision sort ('
      IF (mode.EQ.0) THEN
        WRITE(*,*) 'synchronous)  **'
      ELSE
        WRITE(*,*) 'asynchronous) **'
      ENDIF

      IF (mode.EQ.0) THEN
        CALL fnetsl('dqsort()',status,4,tosort,sorted)
      ELSE
        CALL fnetslnb('dqsort()',status,4,tosort,sorted)
      ENDIF

      IF (status.LT.0) THEN
        CALL FNETSLERR(status)
        WRITE(*,'(A75)') 'Result: Failure'
        RETURN
      ENDIF


      IF (mode.EQ.1) THEN
        request = status
        IF (request.GE.0) THEN
          CALL fnetslpr(request,status)
          WRITE(*,'(A,$)') '.'
70        CONTINUE
          IF (status.NE.NetSolveNotReady) THEN
            GOTO 80
          ENDIF
          DO 15 ii=1,500
             iii = ii + 3*ii
15        CONTINUE
C         WRITE(*,'(A,$)') '.'
          CALL fnetslpr(request,status)
          GOTO 70
80        WRITE(*,*) ' '
          IF (status.EQ.NetSolveOK) THEN
            CALL fnetslwt(request,status)
          ENDIF
        ENDIF
      ENDIF


      IF (status .NE. NetSolveOK) THEN
        CALL fnetslerr(status)
        WRITE(*,'(A75)') 'Result: Failure'
      ELSE
        IF ((sorted(1).NE.(1.0)).OR.(sorted(2).NE.(2.0)).OR.
     $      (sorted(3).NE.(3.0)).OR.(sorted(4).NE.(4.0))) THEN
          WRITE(*,*) 'Array not correctly sorted : ',sorted(1),
     $               sorted(2),sorted(3),sorted(4)
          WRITE(*,'(A75)') 'Result: Failure'
        ELSE
          WRITE(*,'(A75)') 'Result: Success'
        ENDIF
      ENDIF

      RETURN
      END

    
C
C totalTest()
C
      SUBROUTINE totalTest(mode)
      INCLUDE '../../include/fnetsolve.h'
      INTEGER mode
      INTEGER request, status,i,j, ii, iii

      INTEGER ok

      INTEGER   intscalar
      CHARACTER charscalar
      CHARACTER bytescalar
      REAL      floatscalar
      DOUBLE    PRECISION doublescalar
      COMPLEX   scomplexscalar
      DOUBLE    COMPLEX dcomplexscalar

      INTEGER   intvectorm
      PARAMETER(intvectorm = 2)
      INTEGER   charvectorm
      PARAMETER(charvectorm = 2)
      INTEGER   bytevectorm
      PARAMETER(bytevectorm = 2)
      INTEGER   floatvectorm
      PARAMETER(floatvectorm = 2)
      INTEGER   doublevectorm
      PARAMETER(doublevectorm = 2)
      INTEGER   scomplexvectorm
      PARAMETER(scomplexvectorm = 2)
      INTEGER   dcomplexvectorm
      PARAMETER(dcomplexvectorm = 2)

      INTEGER   intvector(intvectorm)
      CHARACTER charvector(charvectorm)
      CHARACTER bytevector(bytevectorm)
      REAL      floatvector(floatvectorm)
      DOUBLE    PRECISION doublevector(doublevectorm)
      COMPLEX   scomplexvector(scomplexvectorm)
      DOUBLE    COMPLEX dcomplexvector(dcomplexvectorm)
 
      INTEGER   intmatrixm
      INTEGER   intmatrixn
      INTEGER   intmatrixl
      PARAMETER(intmatrixm = 2)
      PARAMETER(intmatrixn = 2)
      PARAMETER(intmatrixl = 2)
      INTEGER   charmatrixm
      INTEGER   charmatrixn
      INTEGER   charmatrixl
      PARAMETER(charmatrixm = 2)
      PARAMETER(charmatrixn = 2)
      PARAMETER(charmatrixl = 2)
      INTEGER   bytematrixm
      INTEGER   bytematrixn
      INTEGER   bytematrixl
      PARAMETER(bytematrixm = 2)
      PARAMETER(bytematrixn = 2)
      PARAMETER(bytematrixl = 2)
      INTEGER   floatmatrixm
      INTEGER   floatmatrixn
      INTEGER   floatmatrixl
      PARAMETER(floatmatrixm = 2)
      PARAMETER(floatmatrixn = 2)
      PARAMETER(floatmatrixl = 2)
      INTEGER   doublematrixm
      INTEGER   doublematrixn
      INTEGER   doublematrixl
      PARAMETER(doublematrixm = 2)
      PARAMETER(doublematrixn = 2)
      PARAMETER(doublematrixl = 2)
      INTEGER   scomplexmatrixm
      INTEGER   scomplexmatrixn
      INTEGER   scomplexmatrixl
      PARAMETER(scomplexmatrixm = 2)
      PARAMETER(scomplexmatrixn = 2)
      PARAMETER(scomplexmatrixl = 2)
      INTEGER   dcomplexmatrixm
      INTEGER   dcomplexmatrixn
      INTEGER   dcomplexmatrixl
      PARAMETER(dcomplexmatrixm = 2)
      PARAMETER(dcomplexmatrixn = 2)
      PARAMETER(dcomplexmatrixl = 2)

      INTEGER   intmatrix(intmatrixl,intmatrixn)
      CHARACTER charmatrix(charmatrixl,charmatrixn)
      CHARACTER bytematrix(bytematrixl,bytematrixn)
      REAL      floatmatrix(floatmatrixl,floatmatrixn)
      DOUBLE    PRECISION doublematrix(doublematrixl,doublematrixn)
      COMPLEX   scomplexmatrix(scomplexmatrixl,scomplexmatrixn)
      DOUBLE    COMPLEX dcomplexmatrix(dcomplexmatrixl,dcomplexmatrixn)
 
      INTEGER one
      CHARACTER string(3)

      EXTERNAL fnetsl, fnetslnb, fnetslerr, fnetslpr, fnetslwt

      one=1
      ok=1

      WRITE(*,'(A,$)') '** total test ('
      IF (mode.EQ.0) THEN
        WRITE(*,*) 'synchronous)  **'
      ELSE
        WRITE(*,*) 'asynchronous) **'
      ENDIF
    
C     Assigning the initial values

      intscalar = 2
      charscalar = 'a'
      bytescalar = 'a'
      floatscalar = 2.0
      doublescalar = 2.D0
      scomplexscalar = (2.0,2.0)
      dcomplexscalar = (2.D0,2.D0)

      DO 101 i=1,intvectorm
        intvector(i) = 2
101   CONTINUE
      DO 102 i=1,charvectorm
        charvector(i) = 'a'
102   CONTINUE
      DO 103 i=1,bytevectorm
        bytevector(i) = 'a'
103   CONTINUE
      DO 104 i=1,floatvectorm
        floatvector(i) = 2.0
104   CONTINUE
      DO 105 i=1,doublevectorm
        doublevector(i) = 2.D0
105   CONTINUE
      DO 106 i=1,scomplexvectorm
        scomplexvector(i) = (2.0,2.0)
106   CONTINUE
      DO 107 i=1,dcomplexvectorm
        dcomplexvector(i) = (2.D0,2.D0)
107   CONTINUE

      DO 110 i = 1,intmatrixn
        DO 120 j = 1,intmatrixm
          intmatrix(j,i) = 2
120     CONTINUE
110   CONTINUE
      DO 111 i = 1,charmatrixn
        DO 121 j = 1,charmatrixm
          charmatrix(j,i) = 'a'
121     CONTINUE
111   CONTINUE
      DO 112 i = 1,bytematrixn
        DO 122 j = 1,bytematrixm
          bytematrix(j,i) = 'a'
122     CONTINUE
112   CONTINUE
      DO 113 i = 1,floatmatrixn
        DO 123 j = 1,floatmatrixm
          floatmatrix(j,i) = 2.0
123     CONTINUE
113   CONTINUE
      DO 114 i = 1,doublematrixn
        DO 124 j = 1,doublematrixm
          doublematrix(j,i) = 2.0
124     CONTINUE
114   CONTINUE
      DO 115 i = 1,scomplexmatrixn
        DO 125 j = 1,scomplexmatrixm
          scomplexmatrix(j,i) =  (2.0,2.0)
125     CONTINUE
115   CONTINUE
      DO 116 i = 1,dcomplexmatrixn
        DO 126 j = 1,dcomplexmatrixm
          dcomplexmatrix(j,i) = (2.D0,2.D0)
126     CONTINUE
116   CONTINUE

      string(1) = 'A'
      string(2) = 'B'
      string(3) = 'C'
    
      IF (mode.EQ.0) THEN
        CALL fnetsl('totaltest()',status,
     $  intscalar,intvector,intvectorm,intmatrix,intmatrixm,
     $  intmatrixn,intmatrixl,charscalar,charvector,charvectorm,
     $  charmatrix,charmatrixm,charmatrixn,charmatrixl,
     $  floatscalar,floatvector,floatvectorm,floatmatrix,
     $  floatmatrixm,floatmatrixn,floatmatrixl,doublescalar,
     $  doublevector,doublevectorm,doublematrix,doublematrixm,
     $  doublematrixn,doublematrixl,scomplexscalar,scomplexvector,
     $  scomplexvectorm,scomplexmatrix,scomplexmatrixm,
     $  scomplexmatrixn,scomplexmatrixl,dcomplexscalar,dcomplexvector,
     $  dcomplexvectorm,dcomplexmatrix,dcomplexmatrixm,
     $  dcomplexmatrixn,dcomplexmatrixl,bytescalar,bytevector,
     $  bytevectorm,bytematrix,bytematrixm,bytematrixn,bytematrixl,
     $  string)
      ELSE
        CALL fnetslnb('totaltest()',status,
     $  intscalar,intvector,intvectorm,intmatrix,intmatrixm,
     $  intmatrixn,intmatrixl,charscalar,charvector,charvectorm,
     $  charmatrix,charmatrixm,charmatrixn,charmatrixl,
     $  floatscalar,floatvector,floatvectorm,floatmatrix,
     $  floatmatrixm,floatmatrixn,floatmatrixl,doublescalar,
     $  doublevector,doublevectorm,doublematrix,doublematrixm,
     $  doublematrixn,doublematrixl,scomplexscalar,scomplexvector,
     $  scomplexvectorm,scomplexmatrix,scomplexmatrixm,
     $  scomplexmatrixn,scomplexmatrixl,dcomplexscalar,dcomplexvector,
     $  dcomplexvectorm,dcomplexmatrix,dcomplexmatrixm,
     $  dcomplexmatrixn,dcomplexmatrixl,bytescalar,bytevector,
     $  bytevectorm,bytematrix,bytematrixm,bytematrixn,bytematrixl,
     $  string)
      ENDIF

      IF (status.LT.0) THEN
        CALL FNETSLERR(status)
        WRITE(*,'(A75)') 'Result: Failure'
        RETURN
      ENDIF

    
      IF (mode.EQ.1) THEN
        request = status
        IF (request.GE.0) THEN
          CALL fnetslpr(request,status)
          WRITE(*,'(A,$)') '...'
90        CONTINUE
          IF (status.NE.NetSolveNotReady) THEN
            GOTO 100
          ENDIF
          DO 15 ii=1,500
             iii = ii + 3*ii
15        CONTINUE
C         WRITE(*,'(A,$)') '.'
          CALL fnetslpr(request,status)
          GOTO 90
100       WRITE(*,*) ' '
          IF (status.EQ.NetSolveOK) THEN
            CALL fnetslwt(request,status)
          ENDIF
        ENDIF
      ENDIF

    
      IF (status.NE.NetSolveOK) THEN
        CALL fnetslerr(status)
        WRITE(*,'(A75)') 'Result: Failure'
        ok = 0
      ELSE
C     Checking the validity of the data

C     SCALARS

        IF (intscalar.NE.3) THEN
          WRITE(*,*) '  WARNING : Error on the "integer scalar"'
          WRITE(*,*) '            ( 3 but got ',intscalar,')'
          ok = 0
        ENDIF
        IF (charscalar.NE.'b') THEN
          WRITE(*,*) '  WARNING : Error on the "char scalar"'
          WRITE(*,*) '            ( "b" but got  "',charscalar,'")'
          ok = 0
        ENDIF
        IF (floatscalar.NE.3.0) THEN
          WRITE(*,*) '  WARNING : Error on the "float scalar"'
          WRITE(*,*) '            ( 3.0 but got ',floatscalar,')'
          ok = 0
        ENDIF
        IF (doublescalar.NE.3.D0) THEN
          WRITE(*,*) '  WARNING : Error on the "double scalar"'
          WRITE(*,*) '            ( 3.D0 but got ',doublescalar,')'
          ok = 0
        ENDIF
        IF (scomplexscalar.NE.(3.0,3.0)) THEN
          WRITE(*,*) '  WARNING : Error on the "scomplex scalar"'
          WRITE(*,*) '  ( 3.0+i*3.0 but got ',scomplexscalar,')'
          ok = 0
        ENDIF
        IF (dcomplexscalar.NE.(3.0,3.0)) THEN
          WRITE(*,*) '  WARNING : Error on the "dcomplex scalar"'
          WRITE(*,*) ' ( 3.D0+i*3.D03 but got ',dcomplexscalar,')'
          ok = 0
        ENDIF
  
C
C No test for bytes
C
  
C     VECTORS
  
        DO 200 i=1,intvectorm
          IF (intvector(i).NE.3) THEN
            WRITE(*,*) '  WARNING : Error on the "integer vector"'
            WRITE(*,*) '            ( 3 but got ',intvector(i),')'
            ok = 0
          ENDIF
200     CONTINUE
        DO 201 i=1,charvectorm
          IF (charvector(i).NE.'b') THEN
            WRITE(*,*) '  WARNING : Error on the "char vector"'
            WRITE(*,*) '          ( "b" but got "',charvector(i),'")'
            ok = 0
          ENDIF
201     CONTINUE
        DO 202 i=1,floatvectorm
          IF (floatvector(i).NE.3.0) THEN
            WRITE(*,*) '  WARNING : Error on the "float vector"'
            WRITE(*,*) '         ( 3.0 but got ',floatvector(i),')'
            ok = 0
          ENDIF
202     CONTINUE
        DO 203 i=1,doublevectorm
          IF (doublevector(i).NE.3.D0) THEN
            WRITE(*,*) '  WARNING : Error on the "double vector"'
            WRITE(*,*) '         ( 3.D0 but got ',doublevector(i),')'
            ok = 0
          ENDIF
203     CONTINUE
        DO 204 i=1,scomplexvectorm
          IF (scomplexvector(i).NE.(3.0,3.0)) THEN
            WRITE(*,*) '  WARNING : Error on the "scomplex vector"'
            WRITE(*,*) '  ( 3.0+i*3.0 but got ',scomplexvector(i),')'
            ok = 0
          ENDIF
204     CONTINUE
        DO 205 i=1,dcomplexvectorm
          IF (dcomplexvector(i).NE.(3.D0,3.D0)) THEN
            WRITE(*,*) '  WARNING : Error on the "dcomplex vector"'
            WRITE(*,*) '  ( 3.D0+i*3.D0 but got ',dcomplexvector(i),')'
            ok = 0
          ENDIF
205     CONTINUE
  
C
C No test fo bytes
C
  
C     MATRIX
  
        DO 206 i=1,intmatrixn
          DO 207 j=1,intmatrixm
            IF (intmatrix(j,i).NE.3) THEN
              WRITE(*,*) '  WARNING : Error on the "integer matrix"'
              WRITE(*,*) '            ( 3 but got ',intmatrix(j,i),')'
              ok = 0
            ENDIF
207       CONTINUE
206     CONTINUE
        DO 208 i=1,charmatrixn
          DO 209 j=1,charmatrixm
            IF (charmatrix(j,i).NE.'b') THEN
              WRITE(*,*) '  WARNING : Error on the "char matrix"'
              WRITE(*,*) '    ( b but got  ',charmatrix(j,i),')'
              ok = 0
            ENDIF
209       CONTINUE
208     CONTINUE
        DO 210 i=1,floatmatrixn
          DO 211 j=1,floatmatrixm
            IF (floatmatrix(j,i).NE.3.0) THEN
              WRITE(*,*) '  WARNING : Error on the "float matrix"'
              WRITE(*,*) '      ( 3.0 but got ',floatmatrix(j,i),')'
              ok = 0
            ENDIF
211       CONTINUE
210     CONTINUE
        DO 212 i=1,doublematrixn
          DO 213 j=1,doublematrixm
            IF (doublematrix(j,i).NE.3.D0) THEN
              WRITE(*,*) '  WARNING : Error on the "double matrix"'
              WRITE(*,*) '     ( 3.D0 but got ',doublematrix(j,i),')'
              ok = 0
            ENDIF
213       CONTINUE
212     CONTINUE
        DO 214 i=1,scomplexmatrixn
          DO 215 j=1,scomplexmatrixm
            IF (scomplexmatrix(j,i).NE.(3.0,3.0)) THEN
              WRITE(*,*) ' WARNING : Error on the "scomplex matrix"'
              WRITE(*,*) ' ( 3.0+i*3.0 but got ',scomplexmatrix(j,i),')'
              ok = 0
            ENDIF
215       CONTINUE
214     CONTINUE
        DO 216 i=1,dcomplexmatrixn
          DO 217 j=1,dcomplexmatrixm
            IF (dcomplexmatrix(j,i).NE.(3.D0,3.D0)) THEN
              WRITE(*,*) 'WARNING : Error on the "dcomplex matrix"'
              WRITE(*,*) '(3.D0+i*3.D0 but got ',dcomplexmatrix(j,i),')'
              ok = 0
            ENDIF
217       CONTINUE
216     CONTINUE
  
C
C No test for bytes
C
C
C No test on string as this is Fortran
C
      ENDIF
  
      IF (ok.EQ.1) THEN
        WRITE(*,'(A75)') 'Result: Success'
      ELSE
        WRITE(*,'(A75)') 'Result: xxFailure'
      ENDIF
      
      RETURN
      END
    
C
C upfTest()
C
      SUBROUTINE upfTest(mode)
      INCLUDE '../../include/fnetsolve.h'
      INTEGER mode

      INTEGER ii, iii, request, status
      INTEGER input_int,output_int

      EXTERNAL fnetsl, fnetslnb, fnetslerr, fnetslpr, fnetslwt
    
      WRITE(*,'(A,$)') '** upf test ('
      IF (mode.EQ.0) THEN
        WRITE(*,*) 'synchronous)  **'
      ELSE
        WRITE(*,*) 'asynchronous) **'
      ENDIF

      input_int = 3
    
      IF (mode.EQ.0) THEN
        CALL fnetsl('upftest()',status,'upf.f','toto.f',
     $              input_int,output_int)
      ELSE
        CALL fnetslnb('upftest()',status,'upf.f','toto.f',
     $                input_int,output_int)
      ENDIF

      IF (status.LT.0) THEN
        CALL FNETSLERR(status)
        WRITE(*,'(A75)') 'Result: Failure'
        RETURN
      ENDIF

      IF (mode.EQ.1) THEN
        request = status
        IF (request.GE.0) THEN
          CALL fnetslpr(request,status)
          WRITE(*,'(A,$)') '...'
110       CONTINUE
          IF (status.NE.NetSolveNotReady) THEN
            GOTO 120
          ENDIF
          DO 15 ii=1,500
             iii = ii + 3*ii
15        CONTINUE
C         WRITE(*,'(A,$)') '.'
          CALL fnetslpr(request,status)
          GOTO 110
120       WRITE(*,*) ' '
          IF (status.EQ.NetSolveOK) THEN
            CALL fnetslwt(request,status)
          ENDIF
        ENDIF
      ENDIF

    
      IF (status.NE.NetSolveOK) THEN
        CALL fnetslerr(status)
        WRITE(*,'(A75)') 'Result: Failure'
      ELSE
        IF (output_int.NE.4*input_int) THEN
          WRITE(*,*) 'Returned ',output_int,' instead of',4*input_int
          WRITE(*,'(A75)') 'Result: Failure'
        ELSE
          WRITE(*,'(A75)') 'Result: Success'
        ENDIF
      ENDIF
 
      RETURN
      END
