/*****************************************************************/
/*      workload_manager.c                                       */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  alarmHandler()                                               */
/*  startWorkloadManager()                                       */
/*  getMyWorkload()                                              */
/*****************************************************************/

#include <signal.h>
#include "core.h"
#include "serverglobal.h"
#include "workloadmanager.h"
#include <unistd.h>
#include <time.h>

/*
 * alarmHandler()
 */
void alarmHandler(int sig)
{
}

/*
 * startWorkloadManager()
 */
int startWorkloadManager()
{
  int pid;
  int i;
  int sock;
  int nb_agent;
  int diff;
  int workload;
  NS_LinkItem *linkitem;
  NS_AgentDesc *agent;
  time_t date,date1,date2;
  int idate;
  int *last_broadcasted_time;
  int *last_broadcasted;
  int index;
  void alarmHandler();
  NS_Communicator *comm;


  pid = fork();

  if (pid != 0) /* I am the father */
    return pid;

  /* I am the son */
  close (global.sock);   		/* Closing the listening socket */
  signal(SIGTERM,SIG_DFL);
  signal(SIGKILL,SIG_DFL);
  signal(SIGINT,SIG_DFL);

  alarm(0); 				/* Setting up the alarm         */
  signal(SIGALRM,alarmHandler);

  nb_agent = 0;				/* Computing the number  	*/

  linkitem=global.agents->start;
  while(linkitem != NULL)
  {
    linkitem = linkitem->next;
    nb_agent++;
  }
  
  /* Initialize the arrays */
  last_broadcasted = (int *)calloc(nb_agent,sizeof(int));
  last_broadcasted_time = (int *)calloc(nb_agent,sizeof(int));
  workload = getMyWorkload();
  for (i=0;i<nb_agent;i++) {
    last_broadcasted[i] = -SIGNIFICANT_VARIATION;
  }
  
  while(1)
  {
    time(&date1);
    index = 0;
    linkitem = global.agents->start;
    while(linkitem != NULL)
    {
      agent = (NS_AgentDesc *)(linkitem->content);

      /* compute my workload */
      time(&date);
      idate = (int)date;
      workload = getMyWorkload();
      if (workload == -1)
        continue;

      /* Compute the workload variation */
      diff = last_broadcasted[index]-workload;

      if ((diff>=-SIGNIFICANT_VARIATION)&&
          (diff<=SIGNIFICANT_VARIATION)&&
          (idate - last_broadcasted_time[index] < FORCE_BROADCAST))
      {
        linkitem = linkitem->next;
        continue;
      }
     
      /* Send the workload */
      alarm(CONNECT_TIMEOUT);
      sock = connectToSocket(agent->host_desc->hostname,
                               agent->host_desc->IPaddr,
                               agent->port);
      alarm(0);
      if (sock == -1)
      {
        linkitem = linkitem->next;
        continue;
      }
#ifdef DEBUG
       fprintf(stderr,"Broadcasting workload to %s : %d\n",
              agent->host_desc->hostname,workload);
#endif
      comm = initTransaction(sock,DATA_XDR);
      if (comm == NULL)
      {
        endTransaction(comm);
        continue;
      }
      if (sendInt(comm,NS_PROT_WORKLOAD_REPORT) == -1){
        netsolvePerror("sendInt()"); 
      }
      if (sendIPaddr(comm,&(global.my_self->host_desc->IPaddr)) == -1){
        netsolvePerror("sendIPaddr()");
      }
      if (sendInt(comm,global.my_self->port) == -1){
        netsolvePerror("sendInt()"); 
      }
      if (sendInt(comm,workload) == -1){
        netsolvePerror("sendInt()");
      }
      if (sendInt(comm,idate) == -1){
        netsolvePerror("sendInt()"); 
      }
      endTransaction(comm);
      last_broadcasted[index] = workload;
      last_broadcasted_time[index] = idate;
      linkitem = linkitem->next;
    }
    time(&date2);
    sleep((IDLE_TIME - (date2-date1))<0 ? 0 : 
          (IDLE_TIME-(date2-date1)));
  }
} 


/*
 * getMyWorkload()
 *
 * This function returns an integer that represents
 * the current workload of the machine. This is really
 * crude and should be redone using things like the NWS
 * at some point.
 */
int getMyWorkload()
{
  char buf[200];
  char *tmp;
  char *tmp2;
  float essai;
  FILE *stream;

#ifdef irix
  return 58;
#endif
#ifndef PLAT_T3E
  stream = popen("uptime","r");
  if (stream == 0)
  {
    ns_errno = NetSolveSystemError;
    ns_printinfo();
    perror("popen(uptime)");
    return -1;
  }
  while(fgets(buf,100,stream) == 0);

  pclose(stream);

#ifdef irix
  tmp = (char *)mystrstr(buf,"average"); 
#else
  tmp = (char *)strstr(buf,"average"); 
#endif

  tmp+=7;
  
  while(((*tmp) > '9') || ((*tmp)<'0'))
  {
   (char *) tmp++;
  }
  tmp2 = (char *)tmp;
  while( ((*tmp2 <='9')&&(*tmp2 >='0'))||(*tmp2 == '.'))
    (char *)tmp2++;
  *tmp2 = '\0';
  sscanf(tmp,"%f",&essai);
  return ((int)(essai*100));
#else
  return 50;
#endif

}

