/*****************************************************************/
/*      service_util.c                                           */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*  serverInit()                                                 */
/*****************************************************************/

#include "core.h"
#include "serviceutil.h"
#include <fcntl.h>
#include <unistd.h>

/*
 * notifyProxy()
 */
int notifyProxy(NS_IPaddr_type proxy_IPaddr, int proxy_port, int error_code, int ID)
{
  NS_Communicator *comm;

  comm = contactHost(NULL,proxy_IPaddr,proxy_port,DATA_XDR);
  if (comm == NULL)
  {
    netsolvePerror("contactHost()");
    return -1;
  }
  if ((sendInt(comm,NS_PROT_JOB_REPORT) == -1) ||
      (sendInt(comm,ID) == -1) ||
      (sendInt(comm,error_code) == -1))
  {
    netsolvePerror("sendInt()");
    free(comm);
    return -1;
  }
  free(comm);
  return 0;
}

/*
 * serviceFinished()
 */
void notifyServiceFinished(char *hostname,int port, int restriction_index)
{
  int sock;
  NS_Communicator *comm;
  int ack;

  sock = connectToSocket(hostname,0,port);
  if (sock == -1)
  {
    netsolvePerror("connectToSocket()");
    return;
  }

  comm = initTransaction(sock,DATA_XDR);
  if (comm == NULL)
  {
    netsolvePerror("initTransaction()");
    close(sock);
    return;
  } 
  
  if (sendInt(comm,NS_PROT_SERVICE_FINISHED) == -1)
  {
    endTransaction(comm);
    netsolvePerror("sendInt()");  
    return;
  }
  if (sendInt(comm,restriction_index) == -1)
  { 
    endTransaction(comm);
    netsolvePerror("sendInt()");
    return;
  }
  if (recvInt(comm,&ack) == -1)
  {
    endTransaction(comm);
    netsolvePerror("recvInt()");
    return;
  }
  endTransaction(comm);
  return;
}

/*
 * cleanUp()
 */
void cleanUp(char *wd)
{
  char command[256];
  chdir("/");
  sprintf(command,"/bin/rm -rf %s",wd);
  system(command);
  return;
}

/*
 * redirectStdout()
 *
 * redirects a stdout to a file whose descriptor is returned.
 */
int redirectStdout(char *filename)
{
  int fd;
  int newfd;
  /* Open the file */
  fd = open(filename,O_RDWR|O_CREAT,0666);
  if (fd < 0)
  {
    ns_errno = NetSolveFileError;
    return -1;
  }
  close(1);
  newfd = dup(fd);
  close(fd);
  return newfd;
}

/*
 * createDoneFile()
 */
void createDoneFile(char *s)
{
  FILE *f;

  f = fopen("./done","w");
  if (f == NULL)
    return;
  fprintf(f,s);
  fclose(f);
  return;
}
