/*****************************************************************/
/*      server_process_message_sequence.c                        */
/*      Dieter Bachmann                                          */
/*---------------------------------------------------------------*/
/*                                                               */
/*****************************************************************/

#include "core.h"
#include "serverglobal.h"
#include "serverprocessmessage.h"
#include "workloadmanager.h"
#include "pong.h"
#include "generateservice.h"
#include "abort.h"
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <time.h>
/*
 * processProblemSolve_sequence()
 */
void processProblemSolve_sequence(NS_Communicator *comm)
{
  NS_Node     *top_node;
  NS_Node     *tmp_node;
  NS_ProblemDesc **plist;
  int restriction_index;
  NS_IPaddr_type proxy_IPaddr;
  int proxy_port;
  char *agent;

  top_node = netsl_recv_Node(comm);
  if (top_node == NULL)
  {
    netsolvePerror("netsl_recv_Node()");
    return;
  }
  if ((recvString(comm,&agent) == -1) ||
      (recvIPaddr(comm,&proxy_IPaddr) == -1) ||
      (recvInt(comm,&proxy_port) == -1))
  {
    netsolvePerror("");
    return;
  }
  
  tmp_node = top_node;
  while(tmp_node != NULL){  /* for all nodes */

      plist = lookupProblem(tmp_node->pd->nickname);
      if (*plist == NULL){
	  if (sendInt(comm,NS_PROT_PROBLEM_NOT_FOUND) == -1){
	      netsolvePerror("sendInt()");
	      netsl_delete_Nodes(top_node);
	      return;
	  }
	  free(plist);
	  return;
      }
      if (!compareProblemDesc(tmp_node->pd, *plist)){
	  if (sendInt(comm,NS_PROT_BAD_SPECIFICATION) == -1){
	      netsolvePerror("sendInt()");
	      netsl_delete_Nodes(top_node);
	      return;
	  }
	  free(plist);
	  netsl_delete_Nodes(top_node);
	  return;
      }
      /* copying plist to pd - i don't know why */
      free(plist);
      tmp_node=tmp_node->next; /* next node */
  } /* for all nodes */



  /* Workload Threshhold */
  if (global.my_self->workload_threshhold != -1)
  {
    if (global.my_self->workload_threshhold < getMyWorkload())
    {
#ifdef VIEW
      fprintf(stderr,"Job refused: Workload beyond threshhold\n");
#endif
      if (sendInt(comm,NS_PROT_NOT_ALLOWED) == -1)
      {
        netsolvePerror("sendInt()");
        return;
      }
      return;
    }
  }

  /* Restrictions */
  restriction_index = checkRestriction(comm,global.my_self->restrictions,
                  global.my_self->nb_restrictions);
  if (restriction_index == -1)
  {
    if (ns_errno == NetSolveNotAllowed)
    {
#ifdef VIEW
      fprintf(stderr,"Job refused: Not an allowed client at this time\n");
#endif
      if (sendInt(comm,NS_PROT_NOT_ALLOWED) == -1)
      {
        netsolvePerror("sendInt()");
        return;
      }
      return;
    }
    if (ns_errno == NetSolveSystemError)
    {
        /* nothing */
    }
  }

  /* At this point, either we had a system Error or
     we found the restirction slot */

  if (sendInt(comm,NS_PROT_ACCEPTED) == -1)
  {
    netsolvePerror("sendInt()");
    return;
  }
  /*  forking off the scheduleer for the actual sequence */
  generateServiceProcess_sequence(comm,restriction_index,top_node,agent,
				  proxy_IPaddr,proxy_port);

  netsl_delete_Nodes(top_node); /* free node memory (after fork)*/
  return;
}
