/*****************************************************************/
/*      server.c                                                 */
/*      Henri Casanova, Dorian Arnold                            */
/*---------------------------------------------------------------*/
/*  main()                                                       */
/*****************************************************************/

#include "core.h"
#include <signal.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "serverglobal.h"
#include "serverinit.h"
#include "serverprocessmessage.h"
#include "netsolvesignals.h"

/*
 * Main routine. Does nothing but calling the initialization routine
 * and waiting for a network connection
 */
int main(int argc,char **argv)
{
  NS_Socket_type sock;

  /* Initialize the server */
  if (server_init(argc,argv) == -1)
    exit(-1);

  listen(global.sock,MAX_CONNECTIONS);
  while(1)
  {
    
    if ((sock = acceptConnection(global.sock)) == -1)
      continue;

    processMessage(sock);
    fflush(stderr);
    fflush(stdout);
  }
}
