/*****************************************************************/
/*      netsolveupf.c                                            */
/*      Henri Casanova                                           */
/*****************************************************************/

#include "core.h"
#include "netsolveftp.h"
#include "serverglobal.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

/*
 * processFTP()
 */
int processFTP(NS_ProblemDesc *pd,char *wd,char **xname,char **xpath)
{
  char buffer[256];
  char command[256];
  struct stat st;


  /* Compile the new server                     */
  /* make -f Makefile.numerical   $(XDIR)/stuff */      
  sprintf(command,"make -f %s/src/Makefile.numerical ./service-%s",
           global.netsolve_root_path,pd->file);
  fprintf(stderr,"Running '%s'\n",command);
  system(command);
  
  /* Check that everything is allright */
  sprintf(buffer,"./service-%s",pd->file);
  if (stat(buffer,&st))
  {
#ifdef VIEW
    fprintf(stderr,"Compilation failed\n");
#endif
    ns_errno = NetSolveInternalError;
    return -1;
  }
  *xname = strdup(buffer);
  *xpath = strdup(wd);
  return 1;
}
