/*      scalapackutil.c                                          */
/*      Kim Buckner                                              */
/*      Henri Casanova                                           */
/*****************************************************************/

#include "core.h"
#include "scalapackservice.h"
#include "serviceutil.h"
#include <unistd.h>
#include <fcntl.h>
#include <math.h>

/*
 * this initializes a matrix descriptor based upon the type of 
 * of function is being callled.  currently only supports the 
 * basic type
 */

int *descInit(int rows,int cols,int type)
{
  int *desc;

  switch(type)
  {
    case 1:
      desc=(int *)calloc(9,sizeof(int));
      if(desc==NULL) 
      {
#ifdef VIEW
        fprintf(stderr,"Could not allocate a matrix descriptor\n");
#endif
        scalapack_exit("ERROR");
      }

      if(desc[LLD_]<1)
	desc[LLD_]=1;

      desc[M_]=rows;
      desc[N_]=cols;
      desc[DTYPE]=1;
      desc[CTXT_]=MYCONTXT;
      desc[RSRC_]=0;
      desc[CSRC_]=0;
      desc[MB_]=ROW_BLOCK;
      desc[NB_]=COL_BLOCK;

      return desc;
      break;

    default:
#ifdef VIEW
      fprintf(stderr,"Unknown descriptor type\n");
#endif
      return NULL;
  }/* end of switch */
}

/*
 * makeIpiv()
 */
int *makeIpiv(int size)
{
  int rtn;
  int *tmp;

  rtn=HPC_numroc(size,ROW_BLOCK,MYROW,0,PROC_ROWS);

  rtn+=ROW_BLOCK;
  tmp=(int *)calloc(rtn,sizeof(int));
  return tmp;
}

/*
 * scalapack_exit()
 */
void scalapack_exit(char *s)
{
  if (s == NULL)
    createDoneFile("ERROR");
  else
    createDoneFile(s);
  /*Cblacs_gridexit(MYCONTXT); 
  Cblacs_exit(0); */
  /* exit(0); */
}

#ifdef F2CADD_
int mywrite_int_(int *p)
#endif
#ifdef F2CADD__
int mywrite_int__(int *p)
#endif
#ifdef F2CUPCASE
int MYWRITE_INT(int *p)
#endif
#ifdef F2CNOCHANGE
int mywrite_int(int *p)
#endif
{
  fwrite(p,sizeof(int),1,globalfile);
  return(0);
}

#ifdef F2CADD_
int mywrite_double_(double *p)
#endif
#ifdef F2CADD__
int mywrite_double__(double *p)
#endif
#ifdef F2CUPCASE
int MYWRITE_DOUBLE(double *p)
#endif
#ifdef F2CNOCHANGE
int mywrite_double(double *p)
#endif
{
  fwrite(p,sizeof(double),1,globalfile);
  return(0);
}

#ifdef F2CADD_
int myread_int_(int *p)
#endif
#ifdef F2CADD__
int myread_int__(int *p)
#endif
#ifdef F2CUPCASE
int MYREAD_INT(int *p)
#endif
#ifdef F2CNOCHANGE
int myread_int(int *p)
#endif
{
  fread(p,sizeof(int),1,globalfile);
  return(0);
}

#ifdef F2CADD_
int myread_double_(double *p)
#endif
#ifdef F2CADD__
int myread_double__(double *p)
#endif
#ifdef F2CUPCASE
int MYREAD_DOUBLE(double *p)
#endif
#ifdef F2CNOCHANGE 
int myread_double(double *p)
#endif
{
  fread(p,sizeof(double),1,globalfile);
  return(0);
}


/*
 * iterReadInputObjectsFromFiles()
 *
 * Reads the input from file. Only the Matrices are 2-D
 * block distributed fo now.
 */
int iterReadInputObjectsFromFiles(NS_ProblemDesc *pd)
{
  int i;
  char buffer[256];
  int fd;
  NS_Object *obj;

  for (i=0;i<pd->nb_input_objects;i++)
  {
    sprintf(buffer,"./input%d",i);
    obj = pd->input_objects[i];
    switch(obj->object_type)
    {
      case NETSOLVE_MATRIX:
        if (read2DBlockCyclicMatrix(buffer,obj) == -1)
          return -1;
        /* do we need to transpose ? */
        if (obj->attributes.matrix_attributes.major == pd->major)
          break;
	scalapack_exit("MAJORS DON'T MATCH");
	/* Don't do this for now
        Cpdtran(obj->attributes.matrix_attributes.m,
                obj->attributes.matrix_attributes.n,
                1.0,
                obj->attributes.matrix_attributes.ptr,
                1,1,
                obj->attributes.matrix_attributes.d,
                0.0,
                obj->attributes.matrix_attributes.ptr,
                1,1,
                obj->attributes.matrix_attributes.d);
          if (obj->attributes.matrix_attributes.major == COL_MAJOR)
            obj->attributes.matrix_attributes.major = ROW_MAJOR;
          if (obj->attributes.matrix_attributes.major == ROW_MAJOR)
            obj->attributes.matrix_attributes.major = COL_MAJOR;
	    */
        break;
      case NETSOLVE_SPARSEMATRIX:
        obj->attributes.sparsematrix_attributes.m = -1;
        obj->attributes.sparsematrix_attributes.n = -1;
        obj->attributes.sparsematrix_attributes.f = -1;
        obj->attributes.sparsematrix_attributes.major = -1;
        obj->attributes.sparsematrix_attributes.ptr = NULL;
        obj->attributes.sparsematrix_attributes.rc_ptr = NULL;
        obj->attributes.sparsematrix_attributes.rc_index = NULL;
        obj->attributes.sparsematrix_attributes.d = NULL;
        fd = open(buffer,O_RDONLY,0666);
        if (fd < 0)
        {
#ifdef VIEW
          fprintf(stderr,"Impossible to open file '%s'\n",buffer);
#endif
          ns_errno = NetSolveFileError;
          return -1;
        }
        if (readObjectFromFile(fd,pd->input_objects[i]) == -1)
        {
          netsolvePerror("readObjectFromFile()");
          close(fd);
          return -1;
        }
        close(fd);
	break;
      case NETSOLVE_VECTOR:
        obj->attributes.vector_attributes.m = -1;
        obj->attributes.vector_attributes.ptr = NULL;
        obj->attributes.vector_attributes.d = NULL;
        fd = open(buffer,O_RDONLY,0666);
        if (fd < 0)
        {
#ifdef VIEW
          fprintf(stderr,"Impossible to open file '%s'\n",buffer);
#endif
          ns_errno = NetSolveFileError;
          return -1;
        }
        if (readObjectFromFile(fd,pd->input_objects[i]) == -1)
        {
          netsolvePerror("readObjectFromFile()");
          close(fd);
          return -1;
        }
        close(fd);
        break;
      default: /* Every processor need to get the object */
        fd = open(buffer,O_RDONLY,0666);
        if (fd < 0)
        {
#ifdef VIEW
          fprintf(stderr,"Impossible to open file '%s'\n",buffer);
#endif
          ns_errno = NetSolveFileError;
          return -1;
        }
        if (readObjectFromFile(fd,pd->input_objects[i]) == -1)
        {
          netsolvePerror("readObjectFromFile()");
          close(fd);
          return -1;
        }
        close(fd);
        break;
    }
  }
  return 1;
}

/*
 * read2DBlockCyclicMatrix()
 */
int read2DBlockCyclicMatrix(char *filename,NS_Object *obj)
{
  int m,n,major,local_matrix_size;
  void *ptr;
  int *desc;
  int fd;
  int dummy;
  int info[3];

  if((MYROW==0) && (MYCOL==0)) {
    fd = open(filename,O_RDONLY,0666);
    if (fd < 0)
    {
#ifdef VIEW
      fprintf(stderr,"impossible to open file '%s'\n",filename);
#endif
      ns_errno = NetSolveFileError;
      return -1;
    }

    /* At first, everyone reads the sizes */
    /* We cannot do this per processor. There is no guarantee the
     * files are accessible by all processors.  i.e. /tmp
     */

    /* read the object type and the data type */
    if (read(fd,&dummy,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("read()");
      close(fd);
      return -1;
    }
    if (read(fd,&dummy,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("read()");
      close(fd);
      return -1;
    }
    
    if (read(fd,&major,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("read()");
      close(fd);
      return -1;
    }

    if (read(fd,&m,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("read()");
      close(fd);
      return -1;
    }
   

    if (read(fd,&n,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("read()");
      close(fd);
      return -1;
    }
    close(fd);

    obj->attributes.matrix_attributes.major = major;
    obj->attributes.matrix_attributes.m = m;
    obj->attributes.matrix_attributes.n = n;
    info[0]=major;
    info[1]=m;
    info[2]=n;
    /*Cigebs2d(MYCONTXT,"All"," ",1,3,info,1); */
    }
  else {
    /*Cigebr2d(MYCONTXT,"All"," ",1,3,info,1,0,0); */
    major=info[0];
    m=info[1];
    n=info[2];
    obj->attributes.matrix_attributes.major = major;
    obj->attributes.matrix_attributes.m = m;
    obj->attributes.matrix_attributes.n = n;
    }

  /* Allocate the space */
  local_matrix_size = HPC_numroc(m,ROW_BLOCK,MYROW,0,PROC_ROWS) *
                      HPC_numroc(n,COL_BLOCK,MYCOL,0,PROC_COLS);
  ptr = calloc(local_matrix_size,netsolve_sizeof(obj->data_type));
  obj->attributes.matrix_attributes.ptr = ptr;

  /* construct a descriptor */
  desc = descInit(m,n,1);
  obj->attributes.matrix_attributes.d = desc;

  /* allocate some workspace */
  /* not needed
  workspace = (double *)calloc(desc[MB_],netsolve_sizeof(obj->data_type));
  */

  /* Open the file again and call pdlaread */

  /***
   * KIM: I assume only the 1,1 processor should open the file, right ?
   ***/
   /*
  globalfile = fopen(filename,"r");
  if (filename == NULL)
  {
#ifdef VIEW
    fprintf(stderr,"Impossible to open file '%s'\n",filename);
#endif
    free(workspace);
    ns_errno = NetSolveFileError;
    return -1;
  }
#ifdef F2CADD_
  pdlaread_(ptr,desc,&zero,&zero,workspace);
#endif
#ifdef F2CADD__
  pdlaread__(ptr,desc,&zero,&zero,workspace);
#endif
#ifdef F2CUPCASE
  PDLAREAD(ptr,desc,&zero,&zero,workspace);
#endif
#ifdef F2CNOCHANGE
  pdlaread(ptr,desc,&zero,&zero,workspace);
#endif
   
  fclose(globalfile);
  */
  iterread(filename,ptr,desc);
  return 1;
}

/*
 * iterWriteOutputObjectsToFiles()
 *
 * Writes the output to file. Only the Matrices are 2-D
 * block distributed fo now.
 */
int iterWriteOutputObjectsToFiles(int client_major,
          NS_ProblemDesc *pd)
{
  int i;
  char buffer[256];
  int fd;
  NS_Object *obj;

  for (i=0;i<pd->nb_output_objects;i++)
  {
    sprintf(buffer,"./output%d",i);
    obj = pd->output_objects[i];
    switch(obj->object_type)
    {
      case NETSOLVE_MATRIX:
	/*
        if (client_major != pd->major)*/ /* transpose ? */
	/*
        {
          Cpdtran(obj->attributes.matrix_attributes.m,
                obj->attributes.matrix_attributes.n,
                1.0,
                obj->attributes.matrix_attributes.ptr,
                1,1,
                obj->attributes.matrix_attributes.d,
                0.0,
                obj->attributes.matrix_attributes.ptr,
                1,1,
                obj->attributes.matrix_attributes.d);
          obj->attributes.matrix_attributes.major = client_major;
        }
	*/
        
        if (write2DBlockCyclicMatrix(buffer,obj) == -1)
          return -1;
          break;
        break;
      default: /* Processor 0 writes object */
        if ((MYROW!=0)||(MYCOL!=0))
          break;
        fd = open(buffer,O_WRONLY|O_CREAT,0666);
        if (fd < 0)
        {
#ifdef VIEW
          fprintf(stderr,"Impossible to create file '%s'\n",buffer);
#endif
          ns_errno = NetSolveFileError;
          return -1;
        }
        if (writeObjectToFile(fd,obj) == -1)
        {
          close(fd);
          netsolvePerror("writeObjectToFile()");
          return -1;
        }
        close(fd);
        break;
    }
  }
  return 1;
}

/*
 * write2DBlockCyclicMatrix()
 */
int write2DBlockCyclicMatrix(char *filename,NS_Object *obj)
{
  int m,n,major;
  void *ptr;
  int *desc;
  int fd;

  major = obj->attributes.matrix_attributes.major;
  m = obj->attributes.matrix_attributes.m;
  n = obj->attributes.matrix_attributes.n;
  desc = obj->attributes.matrix_attributes.d;
  ptr = obj->attributes.matrix_attributes.ptr;

  if ((MYROW==0)&&(MYCOL==0))
  {
    fd = open(filename,O_WRONLY|O_CREAT,0666);
    if (fd < 0)
    {
#ifdef VIEW
      fprintf(stderr,"impossible to open file '%s'\n",filename);
#endif
      ns_errno = NetSolveFileError;
      return -1;
    }
  
    if (write(fd,&(obj->object_type),sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("write()");
      close(fd);
      return -1;
    }
    if (write(fd,&(obj->data_type),sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("write()");
      close(fd);
      return -1;
    }


    /* Writing the sizes */
    if (write(fd,&major,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("write()");
      close(fd);
      return -1;
    }

    if (write(fd,&m,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("write()");
      close(fd);
      return -1;
    }

    if (write(fd,&n,sizeof(int)) != sizeof(int))
    {
      ns_errno = NetSolveFileError;
      ns_printinfo();
      perror("write()");
      close(fd);
      return -1;
    }
    close(fd);
  }

  /***
   * KIM: I assume only the 1,1 processor should open the file, right ?
   ***/
  if ((MYROW==0)&&(MYCOL==0)) {
    /*
    globalfile = fopen(filename,"a");
    if (globalfile == NULL)
    {
#ifdef VIEW
      fprintf(stderr,"Impossible to open file '%s'\n",filename);
#endif
      free(workspace);
      return -1;
      }
      */
    iterwrite(filename,ptr,desc);
    }
  else {
    iterwrite(NULL,ptr,desc);
    }


  /*
  workspace = (double *)calloc(desc[MB_],sizeof(double));
#ifdef F2CADD_
  pdlawrite_(&m,&n,ptr,&one,&one,desc,&zero,&zero,workspace);
#endif
#ifdef F2CADD__
  pdlawrite__(&m,&n,ptr,&one,&one,desc,&zero,&zero,workspace);
#endif
#ifdef F2CUPCASE
  PDLAWRITE(&m,&n,ptr,&one,&one,desc,&zero,&zero,workspace);
#endif
#ifdef F2CNOCHANGE
  pdlawrite(&m,&n,ptr,&one,&one,desc,&zero,&zero,workspace);
#endif
   */
   
   /*
  if ((MYROW==0)&&(MYCOL==0))
    fclose(globalfile);
  free(workspace);
  */
  return 1;
}

/*
 * HPC_numroc()
 * contributed by Antoine Petitet
 */

int HPC_numroc( const int N, const int NB, const int PROC,
                const int SRCPROC, const int NPROCS )
{
   int   ilocblk, mydist, nblocks;
   nblocks = N / NB;
   if( ( mydist = PROC - SRCPROC ) < 0 ) mydist += NPROCS;
   ilocblk = nblocks / NPROCS;
   mydist -= nblocks - ilocblk * NPROCS;
   return( ( mydist < 0 ) ? ( ilocblk + 1 ) * NB :
         ( ( mydist > 0 ) ? ilocblk * NB : N + NB*( ilocblk - nblocks) ) );
}
