/*****************************************************************/
/*      scalapackservice.c                                       */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "serverglobal.h"
#include "scalapackservice.h"
#include "serviceutil.h"
#include "standardservice.h"
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include "mpi.h"

#ifdef sunos
int __main() { }
int MAIN_() { }
#endif



/*
 * ScaLAPACKService()
 */
int main(int argc, char **argv)
{
  int mypnum;
  int rtn;
  int client_major;
  char *wd;
  int i,j;
  int solved;
  int fd;
  NS_ProblemDesc *pd;
  int stdoutfd;
  char stdoutfile[256];
  char buffer[256];


  /* Initialize the MPI command line arguments */
  MPI_Init(&argc,&argv);

  /* Who am I ? */
  Cblacs_pinfo(&mypnum,&rtn);
 

  /* Parse the comand line */

  if (argc != 7)
  {
#ifdef VIEW
    fprintf(stderr,"ScaLAPACKService: wrong number of command line args.\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }

  wd = argv[1];
  client_major = atoi(argv[2]);
  ROW_BLOCK = atoi(argv[3]);
  COL_BLOCK = atoi(argv[4]);
  PROC_ROWS = atoi(argv[5]);
  PROC_COLS = atoi(argv[6]);
  NUM_PROCS = PROC_ROWS*PROC_COLS;

  chdir(wd);

  Cblacs_get(-1,0,&MYCONTXT);
  Cblacs_gridinit(&MYCONTXT, "R", PROC_ROWS, PROC_COLS);
  Cblacs_gridinfo(MYCONTXT,&i,&j,&MYROW,&MYCOL);

  /********
   * KIM: Should we kill everything if MYROW == -1 ?
   *  This should never happen if this is correctly implemented
   ********/

  if (MYROW == -1) /* I should not be part of the grid */
  {
    Cblacs_gridexit(MYCONTXT);
    Cblacs_exit(0);
    exit(0);
  }

  if ((MYROW==0)&&(MYCOL==0)) {
#ifdef VIEW
    fprintf(stderr,"BLACS Grid initialized: %d x %d\n",PROC_ROWS,PROC_COLS);
#endif
  }

  /* Get the Problem Descriptor */
  sprintf(buffer,"./pb_desc");
  fd = open(buffer,O_RDONLY,0666);
  if (fd < 0)
  {
#ifdef VIEW
    fprintf(stderr,"Impossible to open the Problem Descriptor file.\n");
#endif
    scalapack_exit("ERROR");
  }
  pd = readProblemDescFromFile(fd);
  close(fd);
  
  if (pd == NULL)
  {
#ifdef VIEW
    fprintf(stderr,"Error while reading the Problem Descriptor file.\n");
#endif
    scalapack_exit("ERROR");
  }

#ifdef VIEW
  if ((MYROW==0)&&(MYCOL==0))
    fprintf(stderr,"Solving '%s'\n",pd->nickname);
#endif

  if (ScaLAPACKReadInputObjectsFromFiles(pd) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while reading the input objects.\n");
#endif
    scalapack_exit("ERROR");
  }

  /* Initializes the output objects */
  if (initOutputObjects(pd) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while initializing the output objects.\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }

  /* Redirecting the stdout */
  sprintf(stdoutfile,"%s/netsolve-stdout",wd);
  stdoutfd = redirectStdout(stdoutfile);
  if (stdoutfd == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while redirecting stdout\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }
  
  /* Solve the problem */
  solved = solve(pd,pd->input_objects,pd->output_objects);

  fflush(stdout);
  close(stdoutfd);

  if (solved == NS_PROT_SOLVED)
  {
    if (ScaLAPACKWriteOutputObjectsToFiles(client_major,pd) == -1)
    {
#ifdef VIEW
      fprintf(stderr,"Error while writing the output objects.\n");
#endif
      scalapack_exit("ERROR");
    }
    scalapack_exit("DONE");
  }
  else
    scalapack_exit("ERROR");
  return(0);
}

/*
 * initOutputObjects()
 */
int initOutputObjects(NS_ProblemDesc *pd)
{
  NS_Object **list = pd->output_objects;
  int nb = pd->nb_output_objects;
  char buffer[256];
  int i;

  for (i=0;i<nb;i++)
  {
    /* do special initializations */
    switch(list[i]->object_type)
    {
      case NETSOLVE_FILE: /* Create a file name */
        sprintf(buffer,"fileoutput%d",i);
        list[i]->attributes.file_attributes.filename = strdup(buffer);
        break;
      case NETSOLVE_MATRIX: /* Set the major */
        list[i]->attributes.matrix_attributes.major = pd->major;
        list[i]->attributes.matrix_attributes.l = -1;
        break;
      default: /* Do nothing */
        break;
    }
  }
  return 1;
}

