/*******************

     Register netsolve server to MDS.
     You can see the result at 
"http://mds.globus.org/cgi/mds.cgi?host:mds.globus.org&port:389&base:project=NetSolve,!!ou=PCL,!!o=University!!of!!California!!San!!Diego,!!o=Globus,!!c=US
    
     1. try to retrieve the server entry, and 
     2. if it exists, add problem entry modifing the entry
     3. if it does not exist, add server entry itself

********************/


#include <stdio.h>
#include <sys/time.h>

#include <string.h>
#include <ctype.h>
#include <lber.h>
#include <ldap.h>

#ifndef TRUE
#define TRUE (0 == 0)
#endif

#ifndef FALSE
#define FALSE (!TRUE)
#endif

#define LDAPHOST "mds.globus.org"
#define ATTRIBUTE "testserverpath"

/* work around for absence of ldap_memfree */
#define ldap_memfree free

static LDAP * ld;

#define USERNAME "cn=Michelle Miller, ou=Innovative Computing Laboratory, o=University of Tennessee at Knoxville, o=Globus, c=US"
#define PASSWD   "l3t3mr0ll"

char * com;

void usage(){
  fprintf(stderr, "Usage: %s SERVERNAME [FUNCTION EXECUTABLE]\n", com);
  exit(2);
}


LDAP_start(){
  char * username = USERNAME;
  char * passwd   = PASSWD;
  /** init ldap session */

  if ((ld = ldap_open(LDAPHOST, LDAP_PORT)) == NULL){
    perror("ldap_open");
    exit(1);
  }
  /** then bind */
  if (ldap_simple_bind_s(ld, username, passwd) != LDAP_SUCCESS){
    ldap_perror(ld, "ldap_simple_bind_s");
    exit(1);
  }

#if 0
  if ((ld = ldap_init(LDAPHOST, LDAP_PORT)) == NULL){
    perror("ldap_init");
    exit(1);
  }
#endif
}

LDAP_end(){
  /** close ldap session */
  ldap_unbind(ld);

}

#define ADD_FMT "hostname=%s, project=NetSolve, ou=Innovative Computing Laboratory, o=University of Tennessee at Knoxville, o=Globus, c=US" 

#define new_LDAPMod() ((LDAPMod *)malloc(sizeof(LDAPMod)))

LDAPMod * makeObjectClass(){
  static char *vals[] = {"GlobusTop", "NetSolveHost", NULL};
  LDAPMod * tmp = new_LDAPMod();
  if (tmp == NULL)
    return NULL;
  tmp->mod_op = 0;
  tmp->mod_type = "objectclass";
  tmp->mod_values = vals;
  return tmp;
}

LDAPMod * makeMod(char * type, char * value, int op){
  LDAPMod * tmp = new_LDAPMod();
  char ** vals;
  if (tmp == NULL)
    return NULL;
  vals = (char **)malloc(sizeof(char *) * 2);
  if (vals == NULL)
    return NULL;
  vals[0] = value;
  vals[1] = NULL;
  tmp->mod_op = op;
  tmp->mod_type = type;
  tmp->mod_values = vals;
  return tmp;
}

LDAPMod * makeLastUpdate(int op){
  time_t clock;
  char * pc;
  clock = time(NULL);
  pc = ctime(&clock);
  *(pc+24) = '\0';
  return makeMod("lastUpdate", strdup(pc), op);
}


int LDAP_add_test(char * servername, int num, char ** argv){
  LDAPMod **mods;
  char ENTRYNAME[1000];
  int count, i;

  if (num % 2 != 0){
    fprintf(stderr, "FUNCTIONAME and EXECUTABLE have to be paired\n");
    usage();
  }
  count = num / 2;  /* pair count */

  mods = (LDAPMod **)malloc(sizeof(LDAPMod *) * (4 + count + 1));
  if (mods == NULL){
    fprintf(stderr, "failed to alloc mods");
    exit();
  }

  mods[0] = makeObjectClass();
  mods[1] = makeMod("hostname", servername, 0);
  mods[2] = makeLastUpdate(0);
  mods[3] = makeMod("ttl", "constant", 0);

  for (i = 0; i < count; i++)
    mods[4+i] = makeMod(argv[i*2], argv[i*2+1], 0);

  mods[4+i] = NULL;

  sprintf(ENTRYNAME, ADD_FMT, servername);

  if (ldap_add_s(ld, ENTRYNAME, mods) != LDAP_SUCCESS){
    ldap_perror(ld, "ldap_add_s");
    exit(1);
  }
}


LDAP_modify_test(char * servername, int num, char ** argv){
  char dn[1000];
  LDAPMod mod;
  LDAPMod **mods;
  int count, i;
 
  if (num % 2 != 0){
    fprintf(stderr, "FUNCTIONAME and EXECUTABLE have to be paired\n");
    usage();
  }
  count = num / 2;  /* pair count */

  mods = (LDAPMod **)malloc(sizeof(LDAPMod *) * (1 + count + 1));
  if (mods == NULL){
    fprintf(stderr, "failed to alloc mods");
    exit();
  }

  mods[0] = makeLastUpdate(LDAP_MOD_REPLACE);

  for (i = 0; i < count; i++)
    mods[1+i] = makeMod(argv[i*2], argv[i*2+1], LDAP_MOD_REPLACE);

  mods[1+i] = NULL;

  sprintf(dn, ADD_FMT, servername);

  if (ldap_modify_s(ld, dn, mods) != LDAP_SUCCESS){
    ldap_perror(ld, "ldap_modify_s");
    exit(1);
  }
}

#define SEARCH_BASE "project=NetSolve, ou=Innovative Computing Laboratory, o=University of Tennessee at Knoxville, o=Globus, c=US" 

#define FILTER_FMT "(hostname=%s)"

int LDAP_check_exist(char * servername){
  LDAPMessage * result;
  char filter[100];
  int count;

  sprintf(filter, FILTER_FMT, servername);

  if (ldap_search_s(ld, SEARCH_BASE, LDAP_SCOPE_SUBTREE, 
		    filter, NULL, 0, &result)){
      ldap_perror(ld, "ldap_search_s");
      exit(1);
  }

  if ((count = ldap_count_entries(ld, result)) == -1){
      ldap_perror(ld, "ldap_count_entries");
      exit(1);

  }

  ldap_msgfree(result);
  if (count == 0)
      return FALSE;
  return TRUE;
  

}

main(int argc, char ** argv){
  char * ns_servername;
  com = argv[0];
  if (argc < 2)
    usage(argv[0]);
  ns_servername = argv[1];  

  LDAP_start();

  if (LDAP_check_exist(ns_servername)){
    fprintf(stderr, "there is the entry, try to modify.\n");
    LDAP_modify_test(ns_servername, argc - 2, argv+2);
  }  else {
    fprintf(stderr, "there is not the entry, try to add.\n");
    LDAP_add_test(ns_servername, argc - 2, argv+2);
  }
  LDAP_end();
  fprintf(stderr, "succeeded.\n");
}

