/*****************************************************************/
/*      condorservive.c                                          */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "serverglobal.h"
#include "condorservice.h"
#include "serviceutil.h"
#include <fcntl.h>
#include <string.h>

#ifdef sunos
int __main() { }
int MAIN_() { }
#endif

/*
 * CondorService()
 */
main(int argc, char **argv)
{
  int client_major;
  char message[128];
  int fd;
  NS_ProblemDesc *pd;
  int stdoutfd;
  char stdoutfile[256];
  int solved;
  char *wd;
  int i;

  /* Parse the comand line */

  if (argc != 3)
  {
#ifdef VIEW
    fprintf(stderr,"CondorService: wron number of command line args.\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }

  client_major = atoi(argv[1]);
  wd = argv[2];

  chdir(wd);

  /* Get the Problem Descriptor */
  fd = open("./pb_desc",O_RDONLY);
  if (fd < 0)
  {
#ifdef VIEW
    fprintf(stderr,"Impossible to open the Problem Descriptor file.\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }
  pd = readProblemDescFromFile(fd);
  close(fd);
  
  if (pd == NULL)
  {
#ifdef VIEW
    fprintf(stderr,"Error while reading the Problem Descriptor file.\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }

#ifdef VIEW
  fprintf(stderr,"Solving '%s'\n",pd->nickname);
#endif

  /* reading the input object  */
  if (readInputObjectsFromFiles(pd) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while reading the input objects.\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }

  /* transpose ? */
  for (i=0;i<pd->nb_input_objects;i++)
  {
    if (pd->input_objects[i]->object_type == NETSOLVE_MATRIX ){
      if (pd->input_objects[i]->attributes.matrix_attributes.major != pd->major){
        transposeMatrix(pd->input_objects[i]);
      }
    }
    else if( pd->input_objects[i]->object_type != NETSOLVE_SPARSEMATRIX){
      if (pd->input_objects[i]->attributes.sparsematrix_attributes.major != pd->major){
        transposeSparseMatrix(pd->input_objects[i]);
      }
    }
    else
      continue;
  }

  /* Initializes the output objects */
  if (initOutputObjects(pd) == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while initializing the output objects.\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }

  /* Redirecting the stdout */
  sprintf(stdoutfile,"%s/netsolve-stdout",wd);
  stdoutfd = redirectStdout(stdoutfile);
  if (stdoutfd == -1)
  {
#ifdef VIEW
    fprintf(stderr,"Error while redirecting stdout\n");
#endif
    createDoneFile("ERROR");
    exit(0);
  }
  
  /* Solve the problem */
  solved = solve(pd,pd->input_objects,pd->output_objects);

  fflush(stdout);
  close(stdoutfd);

  if (solved == NS_PROT_SOLVED)
  {
    /* Transpose back ? */
    for (i=0;i<pd->nb_output_objects;i++)
    {
      if (pd->output_objects[i]->object_type == NETSOLVE_MATRIX ){
        if (pd->output_objects[i]->attributes.matrix_attributes.major != client_major){
          transposeMatrix(pd->output_objects[i]);
        }
      }
      else if( pd->output_objects[i]->object_type != NETSOLVE_SPARSEMATRIX){
        if (pd->output_objects[i]->attributes.sparsematrix_attributes.major != client_major){
          transposeSparseMatrix(pd->output_objects[i]);
        }
      }
      else
        continue;
    }

    if (writeOutputObjectsToFiles(pd) == -1)
    {   
#ifdef VIEW
      fprintf(stderr,"Error while writing the output objects.\n");
#endif
      createDoneFile("ERROR");
      exit(0);
    }   
    sprintf(message,"DONE");
  }
  else
  {  
    sprintf(message,"ERROR");
  }

  createDoneFile(message);
  exit(0);
}

/*
 * initOutputObjects()
 */
int initOutputObjects(NS_ProblemDesc *pd)
{
  NS_Object **list = pd->output_objects;
  int nb = pd->nb_output_objects;
  char buffer[256];
  int i;

  for (i=0;i<nb;i++)
  {
    /* do special initializations */
    switch(list[i]->object_type)
    {
      case NETSOLVE_FILE: /* Create a file name */
        sprintf(buffer,"fileoutput%d",i);
        list[i]->attributes.file_attributes.filename = strdup(buffer);
        break;
      case NETSOLVE_MATRIX: /* Set the major */
        list[i]->attributes.matrix_attributes.major = pd->major;
        list[i]->attributes.matrix_attributes.l = -1;
        break;
      default: /* Do nothing */
        break;
    }
  }
  return 1;
}

