#include <stdio.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
#include "driver/iterative.h"
#include "driver/direct.h"
#ifdef DO_AZTEC
#include "aztec/netsolve_aztec.h"
#include "aztec/aztec_auxs.h"
#endif
#ifdef DO_ITPACK
#include "itpack/netsolve_itpack.h"
#include "itpack/itpack_auxs.h"
#endif
#ifdef DO_MA28
#include "ma28/netsolve_ma28.h"
#endif
#ifdef DO_PETSC
#include "petsc/netsolve_petsc.h"
#include "petsc/petsc_auxs.h"
#endif
#include "driver/direct.h"
#ifdef DO_SUPERLU
#include "superlu/netsolve_superlu.h"
#endif
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "matrix_distr_auxs.h"

int main(int Argc,char **Args)
{
#include "declarations.c"

#include "setup.c"

  {
    int operation;

#define ITRSOLVE 1
#define DIRSOLVE 2

    if (mytid==0) {
      printf("Choose operation (iterative=%d, direct=%d): ",
	     ITRSOLVE,DIRSOLVE);
      scanf("%d",&operation);
    }
    MPI_Bcast(&operation,1,MPI_INT,0,comm);
    
    
    if (operation==ITRSOLVE) {
      iterative_info_block info=0; int package;
      double rtol; int maxit,conv,its;

      if (mytid==0) {
	printf("Choose package (AzTec=%d, Petsc=%d, Itpack=%d, Mec=%d): ",
	       AZTEC,PETSC,ITPACK,MEC_PETSC);
	scanf("%d",&package);
      }
      MPI_Bcast(&package,1,MPI_INT,0,comm);
      
#include "iter_setup.c"

      if (0) {
#ifdef DO_AZTEC
      } else if (PACKAGE_IS(package,AZTEC)) {
	ierr = aztec_allocate_info_block(comm,&info); ERR_ABORT(ierr);
#endif
#ifdef DO_ITPACK
      } else if (PACKAGE_IS(package,ITPACK)) {
	ierr = itpack_allocate_info_block(comm,&info); ERR_ABORT(ierr);
#endif
#ifdef DO_PETSC
      } else if (PACKAGE_IS(package,PETSC)) {
	ierr = petsc_allocate_info_block(comm,&info); ERR_ABORT(ierr);
#endif
#ifdef DO_MEC_PETSC
      } else if (PACKAGE_IS(package,MEC_PETSC)) {
	ierr = mec_petsc_allocate_info_block(comm,&info); ERR_ABORT(ierr);
#endif
      }

      ierr = iterative_set_params(info,rtol,maxit); ERR_ABORT(ierr);

      if (0) {
#ifdef DO_AZTEC
      } else if (PACKAGE_IS(package,AZTEC)) {
#endif
#ifdef DO_ITPACK
      } else if (PACKAGE_IS(package,ITPACK) ) {
	ierr = itpack_params
	  ((itpack_info_block)info,NetsolveChebychev,NetsolveSSOR); ERR_ABORT(ierr);
#endif
#ifdef DO_PETSC
      } else if (PACKAGE_IS(package,PETSC) ) {
	ierr = petsc_params
	  ((petsc_info_block)info,1.e-6,1.e+5,NULL); ERR_ABORT(ierr);
#endif
#ifdef DO_MEC_PETSC
      } else if (PACKAGE_IS(package,MEC_PETSC) ) {
	ierr = petsc_params
	  ((petsc_info_block)info,1.e-6,1.e+5,NULL); ERR_ABORT(ierr);
#endif
      } else {
	printf("Unknown or uninstalled package for tester: <%d>\n",package);
	return 1;
      }
      
      ierr = netsolve_iterative_solve
	(package,Argc,Args,comm, first,local_size,0,
	 values,indices,pointers, rhs_vector,sol_vector,
	 info); ERR_ABORT(ierr);

      ierr = iterative_get_return_params(info,&conv,&its); ERR_ABORT(ierr);

      if (mytid==0) {
	if (conv) {
	  printf("Convergence in %d iterations\n",its);
	} else {
	  printf("No convergence in the specified number of iterations.\n");
	}
      }
    } else if (operation==DIRSOLVE) {
      int package; direct_info_block info=0;

      if (mytid==0) {
	printf("Choose package (ma28=%d, superlu=%d): ",MA28,SUPERLU);
	scanf("%d",&package);
      }
      MPI_Bcast(&package,1,MPI_INT,0,comm);

      if (0) {
#ifdef DO_MA28
      } else if (PACKAGE_IS(package,MA28)) {
	double pivot;
	if (mytid==0) {
	  printf("Pivot parameter 0--1 (0=positional, 1=numerical) : ");
	  scanf("%lf",&pivot); printf("\n");}
	MPI_Bcast(&pivot,1,MPI_DOUBLE,0,comm);
	/* use default of .3 */
	ierr = ma28_params(&info,pivot); ERR_ABORT(ierr);
#endif
#ifdef DO_SUPERLU
      } else if (PACKAGE_IS(package,SUPERLU)) {
	int perm;
	if (mytid==0) {
	  printf("Permutation (0=nat, 1=md(At*A), 2=md(At+A)) : ");
	  scanf("%d",&perm); printf("\n");}
	MPI_Bcast(&perm,1,MPI_INT,0,comm);
	/* use default 1 */
	ierr = superlu_params(&info,perm); ERR_ABORT(ierr);
#endif
      } else {
	printf("Unknown or uninstalled package for tester: <%d>\n",package);
	return 1;
      }

      ierr = netsolve_sparse_direct_solve
	(package,Argc,Args,comm, first,local_size,0,
	 values,indices,pointers,
	 info,
	 rhs_vector,sol_vector); ERR_ABORT(ierr);
    } else {
      printf("unknown operation %d.\n",operation);
    }
  }

#include "unset.c"

  return 0;
}
