#include "mpi.h"
#include "util.h"
#include "netsolve_superlu.h"
#ifdef USE_DIST
#include "superlu_ddefs.h"
#endif
#include "superlu_impl.h"
#include "aux/matrix_auxs.h"
#include "parallel_auxs.h"
#include "driver/direct.h"

static void
CompRow_to_CompCol(int m, int n, int nnz, 
		    double *a, int *colind, int *rowptr,
		    double **at, int **rowind, int **colptr);

int superlu_params(direct_info_block *info,int perm)
{
  superlu_info_block superlu_info;

  superlu_info = (superlu_info_block) malloc
    (sizeof(struct superlu_info_block_));
  superlu_info->perm = perm;
  *info = (direct_info_block) superlu_info;

  return 0;
}

int superlu_driver
(MPI_Comm comm,double *values,int *indices,int *pointers, int order,
 direct_info_block info,
 double *rhs_vector,double *solution_vector)
{
  double *slu_vals;
  int *cptr,*slu_idx,nnzeros, ierr;
#ifdef USE_SERIAL
  int flg;
#endif

  ierr = crs_nnzeros(pointers,order,0,&nnzeros); ERR_RETURN(ierr);
#ifdef DEBUG
  printf("converting matrix\n");
#endif

  CompRow_to_CompCol(order,order,nnzeros, values,indices,pointers,
		     &slu_vals,&slu_idx,&cptr);
  /*
  slu_vals = (double*) malloc(nnzeros*sizeof(double));
  memcpy(slu_vals,values,nnzeros*sizeof(double));
  slu_idx = (int*) malloc(nnzeros*sizeof(int));
  memcpy(slu_idx,indices,nnzeros*sizeof(int));
  cptr = (int*) malloc((order+1)*sizeof(int));
  memcpy(cptr,pointers,(order+1)*sizeof(int));
  */

  /* choose between serial and parallel versions */

#ifdef USE_SERIAL
  ierr = single_proc(comm,&flg); ERR_RETURN(ierr);
  if (flg) {
    ierr = superlu_serial(slu_vals,slu_idx,cptr, nnzeros,order,info,
			  rhs_vector,solution_vector); ERR_RETURN(ierr);
  }
#endif
#ifdef USE_DIST 

  ierr = superlu_dist(comm, slu_vals,slu_idx,cptr, nnzeros,order,info,
		      rhs_vector,solution_vector); ERR_RETURN(ierr);
#endif
  /*  free(slu_vals); free(cptr); free(slu_idx); */

  return 0;
}

/*
 * Convert a row compressed storage into a column compressed storage.
 */
static void
CompRow_to_CompCol(int m, int n, int nnz, 
		    double *a, int *colind, int *rowptr,
		    double **at, int **rowind, int **colptr)
{
    register int i, j, col, relpos;
    int *marker;

    /* Allocate storage for another copy of the matrix. */
    *at = (double *) doubleMalloc(nnz);
    *rowind = (int *) intMalloc(2*nnz);
    *colptr = (int *) intMalloc(2*n+1);
    marker = (int *) intCalloc(n);
    
    /* Get counts of each column of A, and set up column pointers */
    for (i = 0; i < m; ++i)
	for (j = rowptr[i]; j < rowptr[i+1]; ++j) ++marker[colind[j]];
    (*colptr)[0] = 0;
    for (j = 0; j < n; ++j) {
	(*colptr)[j+1] = (*colptr)[j] + marker[j];
	marker[j] = (*colptr)[j];
    }

    /* Transfer the matrix into the compressed column storage. */
    for (i = 0; i < m; ++i) {
	for (j = rowptr[i]; j < rowptr[i+1]; ++j) {
	    col = colind[j];
	    relpos = marker[col];
	    (*rowind)[relpos] = i;
	    (*at)[relpos] = a[j];
	    ++marker[col];
	}
    }

    SUPERLU_FREE(marker);
}


