#include "dsp_defs.h"
int superlu_serial(double *slu_vals,int *slu_idx,int order,int info,
		   double *rhs_vector,double *solution_vector)
{
  SuperMatrix A,B,L,U;
  int perm=superlu_info->perm,*perm_c,*perm_r,err_info;
  dCreate_CompCol_Matrix(&A,order,order,nnzeros, 
			 slu_vals,slu_idx,cptr, NC,_D,GE);
  memcpy(solution_vector,rhs_vector,order*sizeof(double));
  dCreate_Dense_Matrix(&B,order,1,solution_vector,order, DN,_D,GE);
  if (perm<0 || perm>2) {
    printf("Superlu: Illegal permutation value %d.\n",perm);
    return 1;}
  perm_c = (int*) malloc(order*sizeof(int));
  perm_r = (int*) malloc(order*sizeof(int));
  get_perm_c(perm,&A,perm_c);
  dgssv(&A,perm_c,perm_r,&L,&U,&B,&err_info);
  if (err_info) {
    printf("dgssv returned %d ",err_info);
    if (err_info<=A.ncol) 
      printf("(singularity in that row)\n");
    else
      printf("(number of bytes allocated at mem failure)\n");
    return 1;
  }
  return 0;
}
