/*
 * This is the driver for the iterative solvers in Netsolve;
 * currently implemented: aztec, petsc.
 */
#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include "./sparse.h"
#include "netsolve_aztec.h"
#include "netsolve_petsc.h"
#include "netsolve_superlu.h"

int netsolve_iterative_solve
(NETSOLVE_SPARSE_PACKAGE package, int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,int *row_numbers,
 double *values,int *indices,int *pointers,
 double *rhs_vector,double rtol,int maxit,
 double *solution_vector,int *its
) 
{
  int ierr;

#if DEBUG
  printf("entering iterative solve for package <%d>\n",package);
#endif
  if (PACKAGE_IS(package,AZTEC)) {
    ierr = aztec_iterative_driver
      (comm, values,indices,pointers,first,local_size,
       rhs_vector,solution_vector,rtol,maxit,its); ERR_RETURN(ierr);
  } else if (PACKAGE_IS(package,PETSC)) {
    ierr = petsc_iterative_driver
      (Argc,Args,comm,first,local_size,
       values,indices,pointers,
       rhs_vector,rtol,maxit,solution_vector, its); ERR_RETURN(ierr);
  } else {
    printf("Unknown package for iterative solve: <%d>\n",package);
    return -1;
  }
  return 0;
}

int netsolve_sparse_direct_solve
(NETSOLVE_SPARSE_PACKAGE package, int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,int *row_numbers,
 double *values,int *indices,int *pointers,
 double *rhs_vector,double *solution_vector
) 
{
  int ierr;

#if DEBUG
  printf("entering direct sparse solve for package <%d>\n",package);
#endif

  if (PACKAGE_IS(package,SUPERLU)) {
    ierr = superlu_driver
      (comm,values,indices,pointers, local_size, rhs_vector,solution_vector);
     ERR_RETURN(ierr);
  } else {
    printf("Unknown package for sparse direct solve: <%d>\n",package);
    return -1;
  }
  return 0;
}

