#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "petsc.h"
#include "mpi.h"
#include "netsolve_petsc.h"
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "petsc_auxs.h"

int main(int Argc,char **Args)
{
  MPI_Comm  comm;
  int       local_size,total_size = 20,nnzero,first,last;
  int       *idx,*ptr;
  int       ierr;
  double *mv,*xv,*yv;

  ierr = PetscInitialize(&Argc,&Args,PETSC_NULL,PETSC_NULL); ERR_ABORT(ierr);
  if (ierr) printf("Error in MPI Init\n");
  comm = MPI_COMM_WORLD;

  ierr = divide(comm,total_size,&first,&last); ERR_ABORT(ierr);
  if (ierr) printf("Error in vector divide routine\n");
  local_size = last-first;

  construct_crs_system
    (comm, &mv,&idx,&ptr,&nnzero, first,local_size,total_size,&xv,&yv);

#ifdef DEBUG
  ierr = print_crs_matrix(mv,idx,ptr, first,local_size);
#endif

  ierr = petsc_matprod
    (comm, mv,xv,local_size, nnzero,idx,ptr,yv); ERR_ABORT(ierr);

  {
    int i,np;
    MPI_Comm_rank(comm,&np);
    printf("[%d] Return values:",np);
    for (i=0; i<local_size; i++) printf(" %e",yv[i]);
    printf("\n");
  }

  destruct_crs_system(mv,ptr,idx, xv,yv);
  ierr = PetscFinalize(); ERR_ABORT(ierr);

  return 0;
}
