#include <stdlib.h>
#include <stdio.h>
#ifdef petsc29
#include "petscmat.h"
#else
#include "mat.h"
#endif
#include "mpi.h"
#include "error_returns.h"
#include "petsc_matrix_auxs.h"

int petsc_matrix_from_crs
(MPI_Comm comm,int first,int local_size,
 Scalar *mv,int *idx,int *pointers, Mat *A)
{
  int last=first+local_size, row,col, ierr;

  {
    int *dband,*oband;
    dband = (int*) malloc((local_size+1)*sizeof(int));
    oband = (int*) malloc((local_size+1)*sizeof(int));
    for (row=0; row<local_size; row++) {
      dband[row]=0; oband[row]=0;
    }
    for (row=0; row<local_size; row++) {
      for (col=pointers[row]; col<pointers[row+1]; col++) {
	if (idx[col]>=first && idx[col]<last) {
	  dband[row]++;
	} else {
	  oband[row]++;
	}
      }
    }
    ierr = MatCreateMPIAIJ
      (comm,local_size,local_size,PETSC_DECIDE,PETSC_DECIDE,
       0,dband,0,oband,A); ERR_RETURN(ierr);
    free(dband); free(oband);
  }
  for (row=0; row<local_size; row++) {
    for (col=pointers[row]; col<pointers[row+1]; col++) {
      int Row=row+first;
      ierr = MatSetValues(*A,1,&Row,1,idx+col,mv+col,INSERT_VALUES);
      ERR_RETURN(ierr);
    }
  }
  ierr = MatAssemblyBegin(*A,MAT_FINAL_ASSEMBLY); ERR_RETURN(ierr);
  ierr = MatAssemblyEnd(*A,MAT_FINAL_ASSEMBLY); ERR_RETURN(ierr);

  return 0;
}

