#include <stdlib.h>
#include <stdio.h>
#include "driver/iterative.h"
#include "error_returns.h"
#include "netsolve_petsc.h"
#include "./petsc_impl.h"
#include "mpi.h"
#include "petsc_auxs.h"

int petsc_allocate_info_block(MPI_Comm comm,iterative_info_block *info)
{
  petsc_info_block petsc_info;

  ALLOCATE(petsc_info,1,struct petsc_info_block_,
            "petsc info block");
  petsc_info->comm = comm;
  *info = (iterative_info_block) petsc_info;

  return 0;
}

int petsc_params(petsc_info_block petsc_info,
		 double atol,double dtol,
		 int (*convtest)(double,double,double,double,
				 double,double,double,double,
				 int,int,int *)
		 )
{
  petsc_info->atol = atol; petsc_info->dtol = dtol;
  petsc_info->convtest = convtest;

  return 0;
}
