#include <stdio.h>
#include <math.h>
/* general Petsc includes */
#include "petsc.h"
#ifdef petsc29
#include "petscsles.h"
#include "petscmat.h"
#include "petscis.h"
#else
#include "sles.h"
#include "mat.h"
#include "is.h"
#endif
#include "../petsc/petsc_impl.h"
#include "./utah.h"
#include "matrix_auxs.h"
#include "../petsc/netsolve_petsc.h"
#include "netsolve_utah.h"

int utah_iterative_solve
(MPI_Comm comm,
 double *mat_el,double *x_el,
 int first,int isize,int nnzero,
 int *idx,int *pointers,
 double *return_vec_el,
 double rtol,double atol,double dtol,int maxit,
 int *conv,int *its
 );

int utah_iterative_driver
(int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,
 double *values,int *indices,int *pointers,
 double *rhs_vector,double *solution_vector,
 iterative_info_block info)
{
  petsc_info_block petsc_info = (petsc_info_block) info;
  int conv,its,nnz,ierr;

  ierr = ParPreInitialize(&Argc,&Args,PETSC_NULL,PETSC_NULL); ERR_RETURN(ierr);
  ierr = crs_nnzeros(pointers,local_size,0,&nnz); ERR_RETURN(ierr);
  ierr = utah_iterative_solve
    (comm,values,rhs_vector, first,local_size,nnz,
     indices,pointers, solution_vector,
     petsc_info->rtol,petsc_info->atol,petsc_info->dtol,petsc_info->maxit,
     &conv,&its); ERR_RETURN(ierr);
  petsc_set_return_params(petsc_info,conv,its);

  ierr = ParPreFinalize(); ERR_RETURN(ierr);
  return 0;
}

int utah_iterative_solve
(MPI_Comm comm,
 double *mv,double *xv, int first,int local_size,int nz,
 int *idx,int *pointers,
 double *yv,
 double rtol,double atol,double dtol,int maxit,
 int *conv,int *its
 )
{
  Mat       A;
  Vec       X,V;
  int       ierr,p_its;
  Scalar    zero = 0.;

  ierr = VecCreateMPIWithArray(comm,local_size,PETSC_DECIDE,xv,&X); ERR_RETURN(ierr);
  ierr = VecCreateMPIWithArray(comm,local_size,PETSC_DECIDE,yv,&V); ERR_RETURN(ierr);
  ierr = VecSet(&zero,V); ERR_RETURN(ierr);

  ierr = petsc_matrix_from_crs
    (comm,first,local_size,mv,idx,pointers, &A); ERR_RETURN(ierr);
  ierr = UtahSolveSystem(A,X,V,maxit,rtol,atol,dtol,&p_its); CHKERRA(ierr);

  if (p_its<0) {
    *conv = 0; *its = -p_its;
  } else {
    *conv = 1; *its = p_its;}

  ierr = MatDestroy(A); ERR_RETURN(ierr);
  ierr = VecDestroy(X); ERR_RETURN(ierr);
  ierr = VecDestroy(V); ERR_RETURN(ierr);

  return 0;
}

