#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "petsc.h"
#include "mpi.h"
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "mec.h"
#include "./netsolve_mec.h"
#include "../petsc/netsolve_petsc.h"

int main(int Argc,char **Args)
{
#include "../test/declarations.c"
  iterative_info_block info; double rtol; int maxit;

#include "./setup.c"
  if (mytid==0) {
    printf("Relative tolerance : "); scanf("%lf",&rtol); printf("\n");
    printf("Maximum #iterations : "); scanf("%d",&maxit); printf("\n");
  }
  MPI_Bcast(&rtol,1,MPI_DOUBLE,0,comm);
  MPI_Bcast(&maxit,1,MPI_INT,0,comm);

  ierr = petsc_params(&info,rtol,maxit,rtol,1.e+5); ERR_RETURN(ierr);

  ierr = mec_petsc_iterative_driver
    (Argc,Args, MPI_COMM_WORLD, first,local_size,
     values,indices,pointers,
     rhs_vector,sol_vector,
     info); ERR_RETURN(ierr);
  ierr = petsc_get_return_params(info,&conv,&its); ERR_RETURN(ierr);
  if (mytid==0)
    if (conv) {
      printf("The method converged in %d iterations\n",its);
    } else {
      printf("No convergence in the number of iterations specified\n");
    }
  
#include "../test/unset.c"
  free(info);

  return 0;
}
