/*
 * tester for the ma28 direct solver
 */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "./netsolve_ma28.h"

int main(int Argc,char **Args)
{
#include "../test/declarations.c"
  direct_info_block info; double pivot;

#include "../test/setup.c"
  if (mytid==0) {
    printf("Pivot parameter 0--1 (0=positional, 1=numerical) : ");
    scanf("%lf",&pivot); printf("\n");}
  MPI_Bcast(&pivot,1,MPI_DOUBLE,0,comm);

  ierr = ma28_params(&info,pivot); ERR_ABORT(ierr);

  ierr = ma28_driver
    (MPI_COMM_WORLD,
     values,indices,pointers,total_size,
     info,
     rhs_vector,sol_vector); ERR_ABORT(ierr);

#include "../test/unset.c"
  free(info);

  return 0;
}
