/*
 * This is the driver for the iterative solvers in Netsolve.
 */
#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include "sparse_globals.h"
#include "iterative.h"
#include "aztec/netsolve_aztec.h"
#include "itpack/netsolve_itpack.h"
#include "petsc/netsolve_petsc.h"

int netsolve_iterative_solve
(NETSOLVE_SPARSE_PACKAGE package, int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,int *row_numbers,
 double *values,int *indices,int *pointers,
 double *rhs_vector,double *sol_vector,
 iterative_info_block info
) 
{
  int ierr;

#if DEBUG
  printf("entering iterative solve for package <%d>\n",package);
#endif
  if (0) {
#ifdef DO_AZTEC
  } else if (PACKAGE_IS(package,AZTEC)) {
    ierr = aztec_iterative_driver
      (comm, values,indices,pointers,first,local_size,
       rhs_vector,sol_vector, info); ERR_RETURN(ierr);
#endif
#ifdef DO_PETSC
  } else if (PACKAGE_IS(package,PETSC)) {
    ierr = petsc_iterative_driver
      (Argc,Args,comm,first,local_size,
       values,indices,pointers,
       rhs_vector,sol_vector, info); ERR_RETURN(ierr);
#endif
#ifdef DO_MEC_PETSC
  } else if (PACKAGE_IS(package,MEC_PETSC)) {
    ierr = mec_petsc_iterative_driver
      (Argc,Args,comm,first,local_size,
       values,indices,pointers,
       rhs_vector,sol_vector, info); ERR_RETURN(ierr);
#endif
#ifdef DO_ITPACK
  } else if (PACKAGE_IS(package,ITPACK)) {
    ierr = itpack_iterative_driver
      (comm, values,indices,pointers, first,local_size,
       rhs_vector,sol_vector, info); ERR_RETURN(ierr);
#endif
  } else {
    printf("Unknown or uninstalled package for iterative solve: <%d>\n",package);
    return -1;
  }
  return 0;
}

