/*
 * This is the driver for the direct solvers in Netsolve.
 */
#include <stdlib.h>
#include <stdio.h>
#include "mpi.h"
#include "sparse_globals.h"
#include "direct.h"
#include "ma28/netsolve_ma28.h"
#include "superlu/netsolve_superlu.h"

int netsolve_sparse_direct_solve
(NETSOLVE_SPARSE_PACKAGE package, int Argc,char **Args, MPI_Comm comm,
 int first,int local_size,int *row_numbers,
 double *values,int *indices,int *pointers,
 direct_info_block info,
 double *rhs_vector,double *sol_vector
) 
{
  int ierr;

#if DEBUG
  printf("entering direct sparse solve for package <%d>\n",package);
#endif

  if (0) {
#ifdef DO_MA28
  } else if (PACKAGE_IS(package,MA28)) {
    ierr = ma28_driver(comm,values,indices,pointers,local_size,
		       info,
		       rhs_vector,sol_vector); ERR_RETURN(ierr);
#endif
#ifdef DO_SUPERLU
  } else if (PACKAGE_IS(package,SUPERLU)) {

    ierr = superlu_driver
      (comm,values,indices,pointers, local_size,
       info,
       rhs_vector,sol_vector); ERR_RETURN(ierr);
#endif
  } else {
    printf("Unknown or uninstalled package for sparse direct solve: <%d>\n",package);
    return 1;
  }
  return 0;
}

