/*
 * tester for the Aztec iterative solver
 */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
#include "sparse_globals.h"
/* general Aztec includes */
#include "az_aztec.h"
/* specific include for this test */
#include "parallel_auxs.h"
#include "matrix_auxs.h"
#include "./netsolve_aztec.h"
#include "./aztec_auxs.h"
#if LINK_PETSC==1
#include "petsc.h"
#endif

int main(int Argc,char **Args)
{
#include "../test/declarations.c"
  iterative_info_block info; double rtol; int maxit;

#include "../test/setup.c"
#include "../test/iter_setup.c"

  ierr = aztec_allocate_info_block(comm,&info); ERR_RETURN(ierr);
  ierr = iterative_set_params(info,rtol,maxit); ERR_RETURN(ierr);

  ierr = aztec_iterative_driver
    (comm,
     values,indices,pointers, first,local_size,
     rhs_vector,sol_vector,
     info); ERR_RETURN(ierr);

  ierr = iterative_get_return_params(info,&conv,&its); ERR_RETURN(ierr);
  if (mytid==0) {
    if (conv) {
      printf("The method converged in %d iterations\n",its);
    } else {
      printf("No convergence in the number of iterations specified\n");
    }
  }

#include "../test/unset.c"
  free(info);

  return 0;
}
