#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mpi.h"
#include "sparse_globals.h"
/* general Aztec includes */
#include "az_aztec.h"
/* specific include for this test */
#include "netsolve_aztec.h"
#include "aztec_auxs.h"

int aztec_matprod
(MPI_Comm comm, double *mat_el,double *x_el,
 int first,int last, int nnzero, int *idx,
 double *return_vec_el
 )
{
  int proc_config[3];
  int *update_index,*extern_index,*data_org,*cpntr;
  /* unused pointer arrays for the block format */
  int *index=NULL,*bpntr=NULL,*rpntr=NULL;
  int *external,*update,n_update,n_external;
  /*
  int options[AZ_OPTIONS_SIZE];
  double params[AZ_PARAMS_SIZE];
  double status[AZ_STATUS_SIZE];
  */
  int mytid,i;

  MPI_Comm_rank(comm,&mytid);
  AZ_processor_info(proc_config);
  n_update = last-first;
  update = (int *) malloc(n_update*sizeof(int));
  for (i=0; i<n_update; i++) update[i] = first+i;

  AZ_find_local_indices(n_update,idx,update,&external,&n_external,
			AZ_MSR_MATRIX,bpntr);
#ifdef DEBUG
  AZ_check_msr(idx,n_update,n_external,AZ_GLOBAL,proc_config);
#endif
  AZ_transform(proc_config,&external,
	       idx,mat_el,update,
	       &update_index,&extern_index,&data_org,
	       n_update,
	       index,bpntr,rpntr,
	       &cpntr,AZ_MSR_MATRIX);
#ifdef DEBUG
  AZ_check_msr(idx,n_update,n_external,AZ_LOCAL,proc_config);
#endif
  {
    double *invec,*outvec;
    int insize,outsize,i;
    aztec_get_vecsizes(data_org,&insize,&outsize);
    if (n_update!=outsize) 
      ERR_REPORTii("Something fishy: nupdate/outvector size\n",
		   n_update,outsize);

    invec = (double *) malloc(insize*sizeof(double));
    outvec = (double *) malloc(outsize*sizeof(double));
    for (i=0; i<last-first; i++) invec[i]=x_el[i];
    AZ_reorder_vec(invec,data_org,update_index,rpntr);
    AZ_matvec_mult(mat_el,index,idx,rpntr,cpntr,bpntr,
		   x_el,outvec,1,data_org);
#ifdef DEBUG
    if (mytid==0) {
      printf("matprod out vector unordered:");
      for (i=0; i<outsize; i++) printf("%7.3e ",outvec[i]); printf("\n");
    }
#endif
    AZ_invorder_vec(outvec,data_org,update_index,rpntr,return_vec_el);
    free(invec); free(outvec);
  }

  /* free data that I allocated */
  free(update);

  /* free data that Aztec allocated and never deallocated. Tsk. */

  free(external); free(update_index); free(extern_index);
  free(data_org);

  if (mytid==0) printf("check on this deallocation shit\n");
  /*
 free(cpntr);
  */

  return 0;
}
