#ifndef MATRIX_AUXS_H
#define MATRIX_AUXS_H 1
/*
 * Netsolve sparse test matrix functions
 */
#include "mpi.h"

#define DO_NOT_ALLOCATE (double*)-37

extern int construct_crs_system
(double **values,int **indices,int **pointers,int *nnzeros,
 int first,int local_size,int domain_size,int total_size);
extern int destruct_crs_system
(double *mv,int *idx,int *ptr,double *sol,double *rhs,double *tmp);
extern int crs_system_on_proc_grid
(double **mv,int **ptr,int **idx,int *nnzeros,
 int first,int local_size,int domain_size,int total_size,
 int pi,int pj);

extern int construct_crs_vectors
(int first,int local_size,int domain_size,int total_size,
 double **sol_vector,double **rhs_vector,double **tmp_vector);
extern int crs_vectors_on_proc_grid
(int first,int local_size,int domain_size,int total_size,int pi,int pj,
 double **sol,double **rhs,double **tmp);

extern int crs_matmult
(double *values,int *indices,int *pointers,int local_size,
 double *in,double *out);

extern int crs_transpose
(double **mv,int **idx,int **ptr,int first,int local_size);
extern int crs_mat_tobase1
(double *values,int *indices,int *pointers,int order);
extern int crs_mat_tobase0
(double *values,int *indices,int *pointers,int order);
extern int crs_get_blockstructure
(MPI_Comm comm,
 int *idx,int *ptr,int band,int first,int local_size,
 int **blocks,int *nblocks);

extern int drs_to_crs
(double *val,int *idx,int *ptr,int first,int size,int base);
extern int drs_to_crs
(double *val,int *idx,int *ptr,int first,int size,int base);

extern int print_crs_matrix
(double *mv,int *idx,int *ptr,int base,int first,int mysize);
extern int print_crs_matrix_i
(double *mv,int *idx,int *ptr,int base,int* ind,int mysize);
extern int print_drs_matrix
(double *mv,int *idx,int *ptr,int base,int first,int mysize);
extern int crs_nnzeros(int *ptr,int local_size,int base,int *size);
#endif

extern int coo_to_crs(int *ico,int **ptr,int *jco,double *val,
		      int first,int local_size,int nnz);
