/*
 * tester for the Arpack eigensolver
 */
#include <stdlib.h>
#include <stdio.h>
#include "./netsolve_arpack.h"
#include "matrix_auxs.h"
#include "eigen_globals.h"

int main(int Argc,char **Args)
{
  int first=0,size,Size,*indices,*pointers,nnzeros,wanted, ierr;
  double *values,*vectors,*sol_vector,*rhs_vector,*tmp_vector,
    *real_ev,*imag_ev;

  printf("Matrix size: "); scanf("%d",&size); printf("\n");
  Size = size*size;
  printf("Number of eigenvectors: "); scanf("%d",&wanted); printf("\n");
  real_ev = (double*) malloc((wanted+1)*sizeof(double));
  imag_ev = (double*) malloc((wanted+1)*sizeof(double));
  vectors = (double*) malloc(Size*wanted*sizeof(double));

  printf("crs system\n");
  construct_crs_system
    (&values,&indices,&pointers,&nnzeros,
     first,Size,size,Size,
     &sol_vector,&rhs_vector,&tmp_vector);
  /*  print_crs_matrix(values,indices,pointers,0,0,Size);*/
  crs_mat_tobase1(values,indices,pointers,Size);
  /*  print_crs_matrix(values,indices,pointers,1,1,Size);*/
  printf("done\n");

  printf("solving\n");
  arpack_standard_driver(values,indices,pointers,Size,wanted,
			 real_ev,imag_ev,vectors);
  printf("done\n");

  return 0;
}
