#include <sys/time.h>
#ifndef UseTimes
#include <sys/resource.h>
#endif

double time00(void)
{
#ifdef WALL
   struct timeval tp;
   gettimeofday(&tp, NULL);
   return( (double) (tp.tv_sec + tp.tv_usec/1000000.0) ); /* wall clock time */
#else
#ifdef UseTimes
#include <unistd.h>
   struct tms ts;
   static double ClockTick=0.0;

   if (ClockTick == 0.0) ClockTick = (double) sysconf(_SC_CLK_TCK);
   times(&ts);
   return( (double) ts.tms_utime / ClockTick );
#else
   struct rusage ruse;
   getrusage(RUSAGE_SELF, &ruse);
   return( (double)(ruse.ru_utime.tv_sec+ruse.ru_utime.tv_usec / 1000000.0) );
#endif
#endif
}

double time00_(void)
{return time00();}

double TIME00(void)
{return time00();}
