/*****************************************************************/
/*      waitforproxytocomeup.c                                   */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "proxyjobdesc.h"
#include "proxy.h"
#include "lifelink.h"
#include <signal.h>
#include <unistd.h>

#define PROXY_TIMEOUT 10

/*
 * Wait for the proxy to come up
 * and starts the life-link !!!
 */
int waitForProxyToComeUp()
{
  NS_Communicator *comm;
  int i;

#ifdef DEBUG
  ns_printinfo();
  fprintf (STDERR "waitForProxyToComeUp() called\n");
#endif
  for (i=0;i<PROXY_TIMEOUT;i++)
  {

#ifdef DEBUG
  ns_printinfo();
  fprintf (STDERR "waitForProxyToComeUp(): attempt to contactProxy()\n");
#endif
    comm = contactProxy(0);
    if (comm != NULL)
    {

#ifdef DEBUG
  ns_printinfo();
  fprintf (STDERR "waitForProxyToComeUp(): contactProxy() succeeded!\n");
#endif
      if (sendInt(comm,NS_PROT_JUST_CHECKING) != -1)
      {
        if (startLifeLink(getMyIPaddr(),proxy_port,NS_PROT_DIE,0,0) == -1)
        {
          netsolvePerror("startLifeLink()");
          fprintf(STDERR "Cannot start life link to proxy\n");
          return -1;
        }
        endTransaction(comm);
        return 1;
      }
    }
    sleep(1);
  }
#ifdef DEBUG
  ns_printinfo();
  fprintf(STDERR "Proxy not responding!!\n");
#endif
  return -1;
}
