/*****************************************************************/
/*      startproxy.c                                             */
/*      Henri Casanova, Dorian Arnold                            */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "proxy.h"
#include <unistd.h>
#include <signal.h>

int my_major;
int my_data_format;
int proxy_port;

/*
 * Start the proxy 
 *
 * This function starts the proxy as a separate process. It calls
 * waitForProxyToComeUp() which in turn establishes the life link.
 */
int startProxy(char *type,char *agent, int *proxy_pid, int *proxy_port)
{
  int pid;
  int port;
  NS_Socket_type sock;

  /* If there is already a running proxy, kill it !! */
  if (*proxy_pid)
    kill(*proxy_pid,SIGTERM);

#ifdef DEBUG
  ns_printinfo();
  fprintf (STDERR "startProxy(): attempting to bind to port\n");
#endif
  /* Try to bind to a port */
  sock = bindToFirstAvailablePort(PORT_INIT,&port);
  if (sock == -1)
  {
    ns_printinfo();
    fprintf(STDERR "Cannot bind to a port\n");
    ns_errno = NetSolveSystemError;
    return -1;
  }

  /* Now one can fork */
  pid = fork();
  if (pid == -1)
  {
    ns_printinfo();
    perror("fork()");
    ns_errno = NetSolveCannotStartProxy;
    return -1;
  }
  if (pid) /* Father */
  {
    close(sock);
    *proxy_pid = pid; 
    *proxy_port = port;

#ifdef DEBUG
  ns_printinfo();
  fprintf (STDERR "startProxy(): Parent process calls waitForProxyToComeUp()\n");
#endif
    if (waitForProxyToComeUp() == -1)
    {
      perror("waitForProxyToComeUp()");
      ns_errno = NetSolveCannotStartProxy;
      return -1; 
    }
    ns_errno = NetSolveOK;

#ifdef DEBUG
  ns_printinfo();
  fprintf (STDERR "startProxy(): Parent process successfully returns\n");
#endif
    return 1;
  }
  else /* Child */
  {
    char path[256];
    int status;
    char **args;
    char buf[10];

    /* Start the proxy */
    
    if (!strcmp(type,"NetSolve"))
      sprintf(path,"%s/bin/%s/netsolveproxy",NETSOLVE_ROOT,NETSOLVE_ARCH);
    else if (!strcmp(type,"Globus"))
      sprintf(path,"%s/bin/%s/globusproxy",NETSOLVE_ROOT,NETSOLVE_ARCH);
    else {
      fprintf(STDERR "Unknown proxy type\n");
      exit(-1);
    }
    args = (char **)calloc(5,sizeof(char*));
    args[0] = strdup("ns_proxy");
    args[1] = strdup(agent);
    sprintf(buf,"%d",sock);
    args[2] = strdup(buf);
    sprintf(buf,"%d",port);
    args[3] = strdup(buf);
    args[4] = NULL;
    status = execv(path,args);
    exit(-1);
  }
  return 1;
}
