/*****************************************************************/
/*      proxy.c                                                  */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include "proxyjobdesc.h"
#include "netsolveproxy.h"
#include "netsolvesignals.h"

/*
 * Proxy
 *
 * This is the main function for the proxy. It waits for a connection
 * and calls proxyProcessRequest().
 */
int main(int argc, char **argv)
{
  NS_Socket_type sock;
  struct sockaddr_in addr;      /* INET socket address */
  int addrlen;     /* address length      */
  NS_Communicator *comm;
  int listeningsock;


  /* Parse the arguments */
  agent = strdup(argv[1]);
  listeningsock = atoi(argv[2]);
  myport = atoi(argv[3]);
  myIPaddr = getMyIPaddr();

  

  /* Initialize stuff */
  jobs = (NS_JobDesc **)calloc(NB_MAX_JOBS,sizeof(NS_JobDesc*));

  listen(listeningsock,MAX_CONNECTIONS);
  while(1)
  {
    addrlen = sizeof(addr);

#ifdef DEBUG
    fprintf(stderr,"proxy waiting for connection\n"); 
#endif

    if ((sock = acceptConnection(listeningsock)) == -1)
    {
      continue;
    }

    /* Poll for zombies */
    (void)sig_chld(0);

    /* Initiate the transaction */
    comm = acceptTransaction(sock);
    if (comm == NULL)
    {
      netsolvePerror("acceptTransaction()");
      exit(0);
    }
   
#ifdef DEBUG
  fprintf (stderr, "proxy accepted transaction (communication)\n");
#endif

/*
 * Delay the fork until 4 bytes are read
 */
    proxyProcessRequest(comm,listeningsock);
/*      endTransaction(comm); */
  }
}

/*
 * Abort()
 */
int Abort()
{
  fprintf(stderr,"Proxy aborting...\n");
  return 0;
  exit(0);
}

