/*****************************************************************/
/*      proxyutil.c                                              */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"

#ifndef WIN32
#include <unistd.h>
#include <sys/socket.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>

#include "netsolvejobdesc.h"
#include "netsolveproxy.h"


/*
 * submitProblemToServer_sequence()
 */
int submitProblemToServer_sequence(NS_Node *top_node,NS_IPaddr_type IPaddr,
				   int port, int *start_time, int *newport, int *pid)
{
  NS_Communicator *comm;
  int tag;
  time_t now; 
  
  comm = contactHost(NULL,IPaddr,port,DATA_XDR);
  if (comm == NULL)
    return -1;

  /* Sending */
  if ((sendInt(comm,NS_PROT_PROBLEM_SOLVE_SEQUENCE) == -1) ||
      (netsl_send_Nodes(comm,top_node) == -1) ||
      (sendString(comm,agent) == -1) ||
      (sendIPaddr(comm,&myIPaddr) == -1) ||
      (sendInt(comm,myport) == -1))
    
  {
    endTransaction(comm);
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&tag) == -1)
  {
    endTransaction(comm);
    return -1;
  }
  if (tag != NS_PROT_ACCEPTED)
  {
    endTransaction(comm);
    switch(tag)
    {
      case NS_PROT_PROBLEM_NOT_FOUND:
        ns_errno = NetSolveUnknownProblem;
        break;
      case NS_PROT_BAD_SPECIFICATION:
        ns_errno = NetSolveBadProblemSpecification;
        break;
      case NS_PROT_NOT_ALLOWED:
        ns_errno = NetSolveNotAllowed;
        break;
      default:
        ns_errno = NetSolveProtocolError;
        break;
    }
    return -1;
  }

  if (recvInt(comm,newport) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProtocolError;
    return -1;
  }
  if (*newport == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveServerError;
    return -1;
  }

  if (recvInt(comm,pid) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProtocolError;
    return -1;
  }
  endTransaction(comm);

  time(&now);
  *start_time = (int)now;

  return 1;
} /* int submitProblemToServer_sequence(NS_Node *top_node,NS_IPaddr_type IPaddr,
                                        int port, int *start_time, int *newport, int *pid) */


