#include <stdio.h>
#include <sys/time.h>

#include <string.h>
#include <ctype.h>
#include <lber.h>
#include <ldap.h>


#define NETSOLVE_SEARCH_BASE "project=NetSolve, ou=PCL, o=University of California San Diego, o=Globus, c=US" 
#define CONTACT_SEARCH_BASE "o=Globus, c=US" 
#define LDAPHOST "mds.globus.org"
#define NETSOLVE_HOST_FILTER_FMT "(hostname=%s)"
#define ATTRIBUTE "testserverpath"


/* work around for absence of ldap_memfree */
#define ldap_memfree free

static LDAP * ld;

LDAP_start(){
#if 0
  /** init ldap session */
  if ((ld = ldap_init(LDAPHOST, LDAP_PORT)) == NULL){
    perror("ldap_int");
    exit(1);
  }
  /** then bind */
  if (ldap_simple_bind_s(ld, NULL, NULL) != LDAP_SUCCESS){
    ldap_perror(ld, "ldap_simple_bind_s");
    exit(1);
  }
#endif
  if ((ld = ldap_open(LDAPHOST, LDAP_PORT)) == NULL){
    perror("ldap_open");
    exit(1);
  }
}

LDAP_end(){
  /** close ldap session */
  ldap_unbind(ld);

}
char * LDAP_my_search(char * searchBase, char * filter, char *attr);

char * LDAP_ns_search(char * servername, char * attr){
  char filter[1000];
  sprintf(filter, NETSOLVE_HOST_FILTER_FMT, servername);

  return LDAP_my_search(NETSOLVE_SEARCH_BASE, filter, attr);
}

#define CONTACT_FILTER_FMT "(&(objectclass=GlobusResourceManager)(hn=%s))"
#define CONTACT_ATTRIBUTE_NAME "contact"

char * LDAP_contact_search(char * servername){
  char filter[1000];
  sprintf(filter, CONTACT_FILTER_FMT, servername);

  return LDAP_my_search(CONTACT_SEARCH_BASE, filter, 
			CONTACT_ATTRIBUTE_NAME);
}

char * LDAP_my_search(char * searchBase, char * filter, char *attr){
  LDAPMessage * result;
  int n;
  char * ret = NULL;

  /** search */
  if (ldap_search_s(ld, searchBase, LDAP_SCOPE_SUBTREE, 
		   filter, NULL, 0, &result)){
    ldap_perror(ld, "ldap_search_s");
    exit(1);
  }

  {
    LDAPMessage * tmp;
    char ** vals;
    char ** val_tmp;
    char * dn;

    for (tmp = ldap_first_entry(ld, result); tmp != NULL;
	 tmp = ldap_next_entry(ld, tmp)){

      /*
      if ((dn = ldap_get_dn(ld, tmp)) != NULL){
	printf("dn = %s\n", dn);
	ldap_memfree(dn);
      }
      */

      if ((vals = ldap_get_values(ld, tmp, attr)) == NULL){
	continue;
      }
      val_tmp = vals;
      while(*val_tmp != NULL){
	ret = strdup(*val_tmp);
	val_tmp++;
      }
      ldap_value_free(vals);
    }
  }
  ldap_msgfree(result);
  return ret;
}

