/*****************************************************************/
/*      globusproxybasics_sequence.c                             */
/*      Henri Casanova                                           */
/*      Dieter Bachmannn                                         */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include <sys/types.h>
#include <netinet/in.h>
#include "netsolvejobdesc.h"
#include "netsolveproxy.h"
#include "netsolvesignals.h"


/* check server list for one server, and sum the predicted time */
int nstsl_merge_lists (NS_Node *top_node, NS_IPaddr_type IP, int port,
		       int* pred_time) 
{
    int i =0;

    while (top_node != NULL)
    {
	for (i=0; i < top_node->servers->nb_servers; i++)
	{ 
	    if ((top_node->servers->IPaddrlist[i] == IP) &&
		(top_node->servers->portlist[i] == port)) break;
	} 

	if (i ==  top_node->servers->nb_servers)
	    return FALSE;

	*pred_time +=  top_node->servers->predictedtimelist[i];
	top_node = top_node -> next;
    } 

    return TRUE;
} 


/*
 * processSend_sequence_Request()
 */
void processSend_sequence_Request(NS_Communicator *comm)
{
  NS_Node  *top_node = NULL;
  NS_Node  *tmp_node = NULL;
  NS_JobDesc  *jd;
  int ID;
  int status;
  int nb_servers;
  char **hostlist;
  NS_IPaddr_type *IPaddrlist;
  int *portlist;
  int *dataformatlist;
  int *predictedtimelist;
  int i;
  time_t now;
  int tmp;
  int predicted_time;
  int start_time;
  int newport,pid;

  int pred_time;

  NS_Serverlist *serverlist;


  /* receive the info */
  if ((top_node = netsl_recv_Node(comm)) == NULL)
  {
    netsolvePerror("");
    return;
  }
  
  tmp_node = top_node;

/* mm- comment out functionality for now until I determine what makes sense */
#if 0
  while (tmp_node != NULL) {

    /* allocate the server_list space */
    tmp_node->servers = malloc (sizeof(NS_Serverlist)); 
          
    /* Do the actual submission !!! */
    status = submitProblemToAgent (tmp_node->pd->nickname,
		tmp_node->input_size,
		tmp_node->output_size,
		tmp_node->problem_size,
		&tmp_node->servers->nb_servers,
		&tmp_node->servers->hostlist, 
		&tmp_node->servers->IPaddrlist,
		&tmp_node->servers->portlist, 
		&tmp_node->servers->dataformatlist,
		&tmp_node->servers->predictedtimelist,
		agent);

    if (status == -1)  /*error */
    {
      netsl_delete_Nodes(top_node);
      if (sendInt(comm,ns_errno) == -1)
      {
        netsolvePerror("");
	return;
      }
      return;
    }

    tmp_node = tmp_node->next;
  }  /* end while */

  /********************************************/
  /*  Process the lists of servers            */
  /********************************************/

  /* use the top nodes server list for global values */
  serverlist = top_node->servers;

  /* for all servers in the top node */
  for (i = 0; i< top_node->servers->nb_servers; i++){

    pred_time =  top_node->servers->predictedtimelist[i];
    if (nstsl_merge_lists (top_node->next, top_node->servers->IPaddrlist[i],  
			   top_node->servers->portlist[i], &pred_time) == TRUE){

      /* insert server in serverlist */
      serverlist->predictedtimelist[i] = pred_time;
    }
    else {
      serverlist->predictedtimelist[i] = -1;
      serverlist->portlist[i] = -1;
      serverlist->IPaddrlist[i] = 0;
    }
  } /* end for */


  /********************************************/
  /* sort the list to get the fastest server  */
  /********************************************/


  /********************************************/
  /* contact the servers successively         */
  /********************************************/

  jd = NULL;
  for (i=0; i< serverlist->nb_servers; i++)
  {

#ifdef VIEW
    printf("submitting to server:%d\n",i); 
#endif

    /* not a server for all problems */
    if (serverlist->IPaddrlist[i] == 0) continue;

    if (jd != NULL)
      freeJobDesc(jd);
    jd = newJobDesc();
    predicted_time = serverlist->predictedtimelist[i];
    time(&now);
    jd->IPaddr = serverlist->IPaddrlist[i];
    jd->port = serverlist->portlist[i];

    status = submitProblemToServer_sequence(top_node,
			serverlist->IPaddrlist[i], 
			serverlist->portlist[i],
			&start_time, &newport, &pid);
    if (status == -1)
    {
      switch(ns_errno)
      {
        case NetSolveNoServer:
        case NetSolveConnectionRefused:
          forwardFailure (serverlist->IPaddrlist[i],
		top_node->pd->nickname, HOST_ERROR);
          continue;
        case NetSolveNetworkError:
        case NetSolveUnknownProblem:
        case NetSolveServerError:
        case NetSolveProtocolError:
          forwardFailure( serverlist->IPaddrlist[i],top_node->pd->nickname,SERVER_ERROR);
          continue;
        case NetSolveNotAllowed:
          continue;
        case NetSolveUPFError:
        case NetSolveUPFUnsafe:
        case NetSolveBadProblemSpecification:
        case NetSolveFileError:
        case NetSolveInternalError:
        case NetSolveBadValues:
        case NetSolveDimensionMismatch:
        case NetSolveNoSolution:
        case NetSolveSystemError:
          tmp = ns_errno;
          freeJobDesc(jd);
          freeCharStarList( serverlist->hostlist, serverlist->nb_servers);
          free( serverlist->IPaddrlist);
          free( serverlist->portlist);
          free( serverlist->dataformatlist);
          free( serverlist->predictedtimelist);
          ns_errno = tmp;
          status = -1;
          if (sendInt(comm,ns_errno) == -1)
          {
            netsolvePerror("");
            return;
          }
          return;
        case NetSolveOK:
          break;
        default:
          continue;
      } /* end switch */
    } /* end if */
    break;
  } /* end for */

  if (i ==  serverlist->nb_servers)
  {
    freeCharStarList( serverlist->hostlist, serverlist->nb_servers);
    free( serverlist->IPaddrlist);
    free( serverlist->portlist);
    free( serverlist->dataformatlist);
    free( serverlist->predictedtimelist);
    freeJobDesc(jd);
    ns_errno = NetSolveNoServer;
    if (sendInt(comm,ns_errno) == -1)
    {
      netsolvePerror("");
      return;
    }
    return;
  }

  /* Build the Job Descriptor */
  jd = newJobDesc();
  jd->error_code = NetSolveNotReady;
  jd->IPaddr =  serverlist->IPaddrlist[i];
  jd->port =  serverlist->portlist[i];
  jd->pid =  pid;

  /* Request the ID number from the daemon */
  ID = requestInsertJobDesc(jd);
  if (ID == -1)
  {
    status = -1;
    ns_errno = NetSolveTooManyPendingRequests;
    if (sendInt(comm,ns_errno) == -1) 
    {
      netsolvePerror("");
      return;
    }
    return;
  }


  if ((sendInt(comm,NetSolveOK) == -1)                ||
     (sendInt(comm,ID) == -1)       ||
     (sendInt(comm,predicted_time) == -1)       ||
     (sendInt(comm,start_time) == -1)           ||
     (sendIPaddr(comm,&( serverlist->IPaddrlist[i])) == -1)     ||
     (sendString(comm, serverlist->hostlist[i]) == -1)     ||
     (sendInt(comm,newport) == -1)          ||
     (sendInt(comm, serverlist->dataformatlist[i]) == -1))
  {
    netsolvePerror("");
  }
  freeCharStarList( serverlist->hostlist, serverlist->nb_servers);
  free( serverlist->IPaddrlist);
  free( serverlist->portlist);
  free( serverlist->dataformatlist);
  free( serverlist->predictedtimelist);
#endif

  endTransaction(comm);
  return; 
} /* void processSend_sequence_Request(NS_Communicator *comm) */

