/*****************************************************************/
/*      globusproxybasics.c                                      */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include <sys/types.h>
#include <netinet/in.h>
#include "globusjobdesc.h"
#include "globusproxy.h"
#include "netsolvesignals.h"

/*
 * processNumberOfServers()
 */
void processNumberOfServers(NS_Communicator *comm)
{
  int tag,nb_servers;
  NS_Communicator *comm_to_agent;

  /* contact the agent */
  comm_to_agent = contactHost(agent,0,AGENT_PORT,DATA_XDR);
  if (comm_to_agent == NULL)
  {
    sendInt(comm,NetSolveCannotContactAgent);
    netsolvePerror("");
    return;
  }
   
  /* Sending */
  if (sendInt(comm_to_agent,NS_PROT_NB_SERVERS) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  if (recvInt(comm_to_agent,&nb_servers) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  endTransaction(comm_to_agent);

  /* Forward this to the client */
  if (sendInt(comm,NetSolveOK) == -1)
  {
    netsolvePerror("");
    return;
  }
  if (sendInt(comm,nb_servers) == -1)
  {
    netsolvePerror("");
    return;
  }
  return; 
}

/*
 * processAgentList()
 */
void processAgentList(NS_Communicator *comm)
{
  NS_AgentDesc **list;
  int tag,nb_agents,i;
  NS_Communicator *comm_to_agent;

  /* contact the agent */
  comm_to_agent = contactHost(agent,0,AGENT_PORT,DATA_XDR);
  if (comm_to_agent == NULL)
  {
    sendInt(comm,NetSolveCannotContactAgent);
    netsolvePerror("");
    return;
  }
   
  /* Sending */
  if (sendInt(comm_to_agent,NS_PROT_SERVER_LIST) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  if (recvInt(comm_to_agent,&nb_agents) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  list = (NS_AgentDesc **)calloc(nb_agents,sizeof(NS_AgentDesc*));
  for (i=0;i<nb_agents;i++)
  {
    list[i] = recvAgentDesc(comm_to_agent);
    if (list[i] == NULL)
    {
    sendInt(comm,NetSolveNetworkError);
      netsolvePerror("");
      endTransaction(comm_to_agent);
      return;
    }
  }
  endTransaction(comm_to_agent);

  /* Forward this to the proxy */
  if (sendInt(comm,NetSolveOK) == -1)
  {
    netsolvePerror("");
    return;
  }
  if (sendInt(comm,nb_agents) == -1)
  {
    netsolvePerror("");
    return;
  }
  for (i=0;i<nb_agents;i++)
  {
    if (sendAgentDesc(comm,list[i]) == -1)
    {
      netsolvePerror("");
      return;
    }
  }
 
  return; 
}

/*
 * processServerList()
 */
void processServerList(NS_Communicator *comm)
{
  NS_ServerDesc **list;
  int tag,nb_servers,i;
  NS_Communicator *comm_to_agent;

  /* contact the agent */
  comm_to_agent = contactHost(agent,0,AGENT_PORT,DATA_XDR);
  if (comm_to_agent == NULL)
  {
    sendInt(comm,NetSolveCannotContactAgent);
    netsolvePerror("");
    return;
  }
   
  /* Sending */
  if (sendInt(comm_to_agent,NS_PROT_SERVER_LIST) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  if (recvInt(comm_to_agent,&nb_servers) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  list = (NS_ServerDesc **)calloc(nb_servers,sizeof(NS_ServerDesc*));
  for (i=0;i<nb_servers;i++)
  {
    list[i] = recvServerDesc(comm_to_agent);
    if (list[i] == NULL)
    {
      sendInt(comm,NetSolveNetworkError);
      netsolvePerror("");
      endTransaction(comm_to_agent);
      return;
    }
  }
  endTransaction(comm_to_agent);

  /* Forward this to the proxy */
  
  if (sendInt(comm,NetSolveOK) == -1)
  {
    netsolvePerror("");
    return;
  }
  if (sendInt(comm,nb_servers) == -1)
  {
    netsolvePerror("");
    return;
  }
  for (i=0;i<nb_servers;i++)
  {
    if (sendServerDesc(comm,list[i]) == -1)
    {
      netsolvePerror("");
      return;
    }
  }
 
  return; 
}

/*
 * processProblemList()
 */
void processProblemList(NS_Communicator *comm)
{
  NS_ProblemDesc **list;
  int tag,nb_problems,i;
  NS_Communicator *comm_to_agent;

  /* contact the agent */
  comm_to_agent = contactHost(agent,0,AGENT_PORT,DATA_XDR);
  if (comm_to_agent == NULL)
  {
    sendInt(comm,NetSolveCannotContactAgent);
    netsolvePerror("");
    return;
  }
   
  /* Sending */
  if (sendInt(comm_to_agent,NS_PROT_PROBLEM_LIST) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  if (recvInt(comm_to_agent,&nb_problems) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  list = (NS_ProblemDesc **)calloc(nb_problems,sizeof(NS_ProblemDesc*));
  for (i=0;i<nb_problems;i++)
  {
    list[i] = recvProblemDesc(comm_to_agent);
    if (list[i] == NULL)
    {
      sendInt(comm,NetSolveNetworkError);
      netsolvePerror("");
      endTransaction(comm_to_agent);
      return;
    }
  }
  endTransaction(comm_to_agent);

  /* Forward this to the proxy */
  
  if (sendInt(comm,NetSolveOK) == -1)
  {
    netsolvePerror("");
    return;
  }
  if (sendInt(comm,nb_problems) == -1)
  {
    netsolvePerror("");
    return;
  }
  for (i=0;i<nb_problems;i++)
  {
    if (sendProblemDesc(comm,list[i]) == -1)
    {
      netsolvePerror("");
      return;
    }
  }
 
  return; 
}

/*
 * processKillJob()
 */
void processKillJob(NS_Communicator *comm)
{
  int ID;
  NS_JobDesc *jd;
  NS_Communicator *comm_to_server;
  int tag;
  int status;
  int NS_errno;

  if (recvInt(comm,&ID) == -1)
  {
    netsolvePerror("");
    return;
  }
  if ((ID < 0)||(ID>NB_MAX_JOBS))
  {
    sendInt(comm,NetSolveInvalidRequestID);
    return;
  }

  if (jobs[ID] == NULL)
  {
    sendInt(comm,NetSolveInvalidRequestID);
    return;
  }

  jd = jobs[ID];

  /* Kill the job !! */

  ns_errno = NetSolveOK;

  if (sendInt(comm,NS_errno) == -1)
  {
    netsolvePerror("");
    return;
  }
  rmJobDesc(ID);
  return;
}

/*
 * processProblemInfo()
 */
void processProblemInfo(NS_Communicator *comm)
{
  char *nickname;
  NS_Communicator *comm_to_agent;
  int tag;
  NS_ProblemDesc *pd;

  if (recvString(comm,&nickname) == -1)
  {
    netsolvePerror("");
    return;
  }
  
  /* contact the agent */
  comm_to_agent = contactHost(agent,0,AGENT_PORT,DATA_XDR);
  if (comm_to_agent == NULL)
  {
    sendInt(comm,NetSolveCannotContactAgent);
    netsolvePerror("");
    return;
  }
   
  /* Sending */
  if (sendInt(comm_to_agent,NS_PROT_PROBLEM_INFO) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }
  if (sendString(comm_to_agent,nickname) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  /* Receiving */
  if (recvInt(comm_to_agent,&tag) == -1)
  {
    sendInt(comm,NetSolveNetworkError);
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }

  /* Forward the tag */
  if (tag == NS_PROT_PROBLEM_DESC)
  {
    pd = recvProblemDesc(comm_to_agent);
    if (pd == NULL)
    {
      netsolvePerror("");
      sendInt(comm,NetSolveNetworkError);
      endTransaction(comm_to_agent);
      return;
    } 
  }
  endTransaction(comm_to_agent);
  if (tag == NS_PROT_PROBLEM_NOT_FOUND)
  {
    if (sendInt(comm,NetSolveUnknownProblem) == -1)
    {
      netsolvePerror("");
      return;
    }
    return;
  }
  if (sendInt(comm,NetSolveOK) == -1)
  {
    netsolvePerror("");
    return; 
  }

  /* Forward the actual descriptor */
  if (sendProblemDesc(comm,pd) == -1)
  {
    netsolvePerror("");
    return;
  }
  return;
}
 
/*
 * processSendRequest()
 */
void processSendRequest(NS_Communicator *comm)
{
  NS_JobDesc *jd;
  NS_ProblemDesc *pd;
  int input_size,output_size,problem_size;
  int ID;
  int status;
  int nb_servers;
  char **hostlist;
  NS_IPaddr_type *IPaddrlist;
  int *portlist;
  int *dataformatlist;
  int *predictedtimelist;
  int i;
  time_t now;
  int tmp;
  int predicted_time;
  int start_time;
  int newport,pid;


  /* receive the info */
  if ((pd = recvProblemDesc(comm)) == NULL)
  {
    netsolvePerror("");
    return;
  }
  
  if ((recvInt(comm,&input_size) == -1) ||
      (recvInt(comm,&output_size) == -1) ||
      (recvInt(comm,&problem_size) == -1))
  {
    netsolvePerror("");
    return;
  }
        
#if 0
  /* Do the actual submission !!! */
  status = submitProblemToAgent(pd->nickname,input_size,
                 output_size,problem_size,
                 &nb_servers, &hostlist, &IPaddrlist,
                 &portlist, &dataformatlist,
                 &predictedtimelist,agent);

  if (status == -1)
  {
    if (sendInt(comm,ns_errno) == -1)
    {
      netsolvePerror("");
      return;
    }
    return;
  }

  /********************************************/
  /* contact the servers successively         */
  /********************************************/

  jd = NULL;
  for (i=0;i<nb_servers;i++)
  {
    if (jd != NULL)
      freeJobDesc(jd);
    jd = newJobDesc();
    predicted_time = predictedtimelist[i];
    time(&now);
    jd->IPaddr = IPaddrlist[i];
    jd->port = portlist[i];

    status = submitProblemToServer(pd,IPaddrlist[i],portlist[i],&start_time,
                                   &newport,&pid);
    if (status == -1)
    {
      switch(ns_errno)
      {
        case NetSolveNoServer:
        case NetSolveConnectionRefused:
          forwardFailure(IPaddrlist[i],pd->nickname,HOST_ERROR);
          continue;
        case NetSolveNetworkError:
        case NetSolveUnknownProblem:
        case NetSolveServerError:
        case NetSolveProtocolError:
          forwardFailure(IPaddrlist[i],pd->nickname,SERVER_ERROR);
          continue;
        case NetSolveNotAllowed:
          continue;
        case NetSolveUPFError:
        case NetSolveUPFUnsafe:
        case NetSolveBadProblemSpecification:
        case NetSolveFileError:
        case NetSolveInternalError:
        case NetSolveBadValues:
        case NetSolveDimensionMismatch:
        case NetSolveNoSolution:
        case NetSolveSystemError:
          tmp = ns_errno;
          freeJobDesc(jd);
          freeCharStarList(hostlist,nb_servers);
          free(IPaddrlist);
          free(portlist);
          free(dataformatlist);
          free(predictedtimelist);
          ns_errno = tmp;
          status = -1;
          if (sendInt(comm,ns_errno) == -1)
          {
            netsolvePerror("");
            return;
          }
          return;
        case NetSolveOK:
          break;
        default:
          continue;
      }
    }
    break;
  }

  if (i == nb_servers)
  {
    freeCharStarList(hostlist,nb_servers);
    free(IPaddrlist);
    free(portlist);
    free(dataformatlist);
    free(predictedtimelist);
    freeJobDesc(jd);
    ns_errno = NetSolveNoServer;
    if (sendInt(comm,ns_errno) == -1)
    {
      netsolvePerror("");
      return;
    }
    return;
  }

  /* Build the Job Descriptor */
  jd = newJobDesc();
  jd->error_code = NetSolveNotReady;
  jd->IPaddr = IPaddrlist[i];
  jd->port = portlist[i];
  jd->pid = pid;

  /* Request the ID number from the daemon */
  ID = requestInsertJobDesc(jd);
  if (ID == -1)
  {
    status = -1;
    ns_errno = NetSolveTooManyPendingRequests;
    if (sendInt(comm,ns_errno) == -1) 
    {
      netsolvePerror("");
      return;
    }
    return;
  }


  if ((sendInt(comm,NetSolveOK) == -1)                ||
     (sendInt(comm,ID) == -1)       ||
     (sendInt(comm,predicted_time) == -1)       ||
     (sendInt(comm,start_time) == -1)           ||
     (sendIPaddr(comm,&(IPaddrlist[i])) == -1)     ||
     (sendString(comm,hostlist[i]) == -1)     ||
     (sendInt(comm,newport) == -1)          ||
     (sendInt(comm,dataformatlist[i]) == -1))
  {
    netsolvePerror("");
  }
  freeCharStarList(hostlist,nb_servers);
  free(IPaddrlist);
  free(portlist);
  free(dataformatlist);
  free(predictedtimelist);

#endif

  endTransaction(comm);
  return; 
}

/*
 * processServerFailure()
 */
void processServerFailure(NS_Communicator *comm)
{
  NS_IPaddr_type IPaddr;
  char *nickname;
  int error_type;
  NS_Communicator *comm_to_agent;
  int tag;
  int ID;
 
  if ((recvIPaddr(comm,&IPaddr) == -1) ||
      (recvString(comm,&nickname) == -1) ||
      (recvInt(comm,&ID) == -1) ||
      (recvInt(comm,&error_type) == -1))
  {
    netsolvePerror("");
    return;
  }     

  /* contact the agent */
  forwardFailure(IPaddr,nickname,error_type);

  /* contact the daemon */
  rmJobDesc(ID);

  return;
}

/*
 * processProbeRequest()
 */
void processProbeRequest(NS_Communicator *comm)
{
  int ID;
  int status;

  if (recvInt(comm,&ID) == -1)
  {   
    netsolvePerror("");
    return;
  } 
  
  if ((ID<0)||(ID>NB_MAX_JOBS))
  {
    sendInt(comm,NetSolveInvalidRequestID);
    return;
  }
  if (jobs[ID] == NULL)
  {
    sendInt(comm,NetSolveInvalidRequestID);
    return;  
  }
  if ((sendInt(comm,NetSolveOK) == -1) ||
      (sendInt(comm,jobs[ID]->error_code) == -1))
    netsolvePerror("");
  return;
}

/*
 * processJobCompleted()
 */
void processJobCompleted(NS_Communicator *comm)
{
  NS_IPaddr_type IPaddr;
  int ID;
  NS_Communicator *comm_to_agent;
  int tag;

  if ((recvIPaddr(comm,&IPaddr) == -1)||
      (recvInt(comm,&ID) == -1))
  {
    netsolvePerror("");
    return;
  }

  /* contact the agent */
  comm_to_agent = contactHost(agent,0,AGENT_PORT,DATA_XDR);
  if (comm_to_agent == NULL)
  {
    netsolvePerror("");
    return;
  }

  /* Sending */
  if (sendInt(comm_to_agent,NS_PROT_JOB_COMPLETED) == -1)
  {
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }
  if (sendIPaddr(comm_to_agent,&IPaddr) == -1)
  {
    netsolvePerror("");
    endTransaction(comm_to_agent);
    return;
  }
  endTransaction(comm_to_agent);

  /* contact the daemon */
  rmJobDesc(ID);

  return;
}


/*
 * processSendAssignment()
 */
void processSendAssignment(NS_Communicator *comm)
{
  NS_JobDesc *jd;
  NS_ServerDesc *sd;
  NS_ProblemDesc *pd;
  int ID;
  int status;
  NS_IPaddr_type IPaddr;
  int port;
  int data_format;
  time_t now;
  int tmp;
  int start_time;
  int newport,pid;


  /* receive the info */
  if ((pd = recvProblemDesc(comm)) == NULL)
  {
    netsolvePerror("");
    return;
  }
  
  if (recvIPaddr(comm,&IPaddr) == -1)
  {
    netsolvePerror("");
    return;
  }
        
  status = submitProblemToGlobus(pd,IPaddr,&start_time,
                  &newport,&data_format,&jd);


  /* Request an ID number */
  ID = requestInsertJobDesc(jd);
  if (ID == -1)
  {
    ns_errno = NetSolveTooManyPendingRequests;
    if (sendInt(comm,ns_errno) == -1)
    {
      netsolvePerror("");
      return;
    }
    return;
  }

  if ((sendInt(comm,NetSolveOK) == -1)                ||
     (sendInt(comm,ID) == -1)       ||
     (sendInt(comm,start_time) == -1)           ||
     (sendInt(comm,newport) == -1)          ||
     (sendInt(comm,data_format) == -1))
  {
    netsolvePerror("");
  }
  endTransaction(comm);
  return; 
}
