#include "core.h"
#include "psttools.h"
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <sys/stat.h>
#include <stdlib.h>

/*
 * createDirectoryStructure()
 *
 * returns the number of sub-directories created
 */
int createDirectoryStructure(int ninput,char **inputs,
                   int noutput,char **outputs)
{
  int i,j;
  int depth;
  int mindepth=0;
  char command[256];
  char buffer[10];
  char *tmp;
  char **true_inputs; /* deals with the URNs */
  char *getPathForDisk(char*);

  true_inputs = (char **)calloc(ninput,sizeof(char*));
  for (i=0;i<ninput;i++)
  { 
    if (!isRemoteFile(inputs[i]))
      true_inputs[i] = strdup(inputs[i]);
    else
      true_inputs[i] = getRemoteFileName(inputs[i]);
  }

  for (i=0;i<ninput;i++)
  {
    depth = getRelativeDepth(true_inputs[i]);
    if (mindepth > depth)
      mindepth = depth;
  }
  for (i=0;i<noutput;i++)  
  {
    depth = getRelativeDepth(outputs[i]);
    if (mindepth > depth)
      mindepth = depth;
  }

  /* Creating bogus directories */
  for (i=mindepth;i<0;i++)
  {
    if (mkdir("./mcell-tmp/",0777))
      return -1;
    chdir("./mcell-tmp/");
  }

  /* Creating the actual directories */
  for (i=0;i<ninput;i++)
  {
    if (getRelativeDepth(true_inputs[i])==0)
      continue;

    tmp = strdup(true_inputs[i]);
    *(strrchr(tmp,'/')) = '\0';
    sprintf(command,"mkdir -p %s",tmp);
    free(tmp);
    system(command);
  }
  for (i=0;i<noutput;i++)
  {
    if (getRelativeDepth(outputs[i])==0) 
      continue;

    tmp = strdup(outputs[i]);
    *(strrchr(tmp,'/')) = '\0';
    sprintf(command,"mkdir -p %s",tmp);
    free(tmp);
    system(command);
  }

  /* Move the input files around */   
  fprintf(stderr,"There are %d input files\n",ninput);
  for (i=0;i<ninput;i++)
  {
    fprintf(stderr,"inputs[%d] = '%s'\n",i,inputs[i]);
    if (!isRemoteFile(inputs[i]))
    {
      sprintf(command,"mv ");
      for (j=0;j<-mindepth;j++)
        strcat(command,"../");
      strcat(command,"packedfileinput1-");
      sprintf(buffer,"%d",i);
      strcat(command,buffer);
      strcat(command," ./");
      strcat(command,inputs[i]);
      system(command);
    }
    else /* Remote file: soft link */
    {
      char *diskname;
      char *cap;
      char *diskpath;
      
      diskname = getRemoteDisk(inputs[i]) ;
      diskpath = getPathForDisk(diskname); 
      cap = getRemoteCap(inputs[i]) ;

      fprintf(stderr,"cap = '%s'\n",cap);
      fprintf(stderr,"filename = '%s'\n",true_inputs[i]);

      sprintf(command,"ln -s %s/%s ./%s",diskpath,cap,
                                       true_inputs[i]);
      system(command);
    }
  }

  return -mindepth;
}

/*
 * getRelativeDepth()
 */
int getRelativeDepth(char *path)
{
  char *line;
  char *tmp;
  int depth = 0;

  line = strdup(path);
  tmp = strtok(line,"/");
  while (tmp != NULL)
  {
    if (!strcmp(tmp,".."))
      depth--;
    else if (!strcmp(tmp,"."))
      depth = depth;
    else
      depth++;
    tmp = strtok(NULL,"/");
  }
  return depth-1;
}

