import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//import com.util.myjava.*;  // for custom Layout

public class MCallingSequencePanel extends JPanel implements ActionListener
{
 // required for functionality
 InputPanel ip;
 OutputPanel op; 
 private int TotalInputs;
 private int TotalOutputs;
 private int NewTotalInputs;
 private int NewTotalOutputs;
 private java.util.Vector InputNames;
 private java.util.Vector OutputNames;


 // for Status 
 private JLabel StatusLabel;
 private JTable table;
 private JScrollPane StatusPane;
 Object[][] data;
 String[]  columnNames = {"Number","Name", "DataType", "ObjectType", "Description"};
 
 // for displaying the Matlab call example
  JTextArea exArea;
  JScrollPane exPane;

 // for Input and Output sequence

 JPanel PositionPanel; // will contain mip and mop
 JPanel mip;  // MatlabCalling Sequence Input Panel
 JPanel mop;  // MatlabCalling Sequence Output Panel

 java.util.Vector mipSequenceCBox;
 java.util.Vector mopSequenceCBox;

  CustomLayout cl = null;
 boolean mipUpdateCalled = false;
 boolean mopUpdateCalled = false;

 java.util.Vector mipNameLabels;   // just Name and Number in mip panel
 java.util.Vector mopNameLabels;   // just Name and Number in mop panel

 
  public MCallingSequencePanel(InputPanel ip, OutputPanel op)
  {
  // various initialization 
   this.ip = ip;
   this.op = op;


   PositionPanel = new JPanel();
   mip = new JPanel();
   mop = new JPanel();
   
   mipSequenceCBox = new java.util.Vector();
   mopSequenceCBox = new java.util.Vector();
   InputNames = new java.util.Vector();
   OutputNames = new java.util.Vector();

   mipNameLabels = new java.util.Vector();
   mopNameLabels = new java.util.Vector();


   StatusLabel = new JLabel("INPUT/OUTPUT Status");
   data = new Object[1][5];
   table = new JTable(data,columnNames);
  
   table.setPreferredScrollableViewportSize(new Dimension(750, 400));
   StatusPane = new JScrollPane(table);
   StatusPane.setMaximumSize(new Dimension(750,400));
   StatusPane.setSize(StatusPane.getMaximumSize());
StatusPane.setPreferredSize(new Dimension(750,350));

   table.setEnabled(false);


   // Initialize the exArea and exPane
   exArea = new JTextArea();
   exPane = new JScrollPane(exArea);
   exArea.setMaximumSize(new Dimension(750,200));
   exPane.setMaximumSize(new Dimension(750,200));
   exArea.setSize(exArea.getMaximumSize());
exPane.setPreferredSize(new Dimension(750,exArea.getMaximumSize().height));



  // setLayout for the panels
   setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
   PositionPanel.setLayout(new BoxLayout(PositionPanel,BoxLayout.X_AXIS));


   
   // add mip and mop to Position Panel 

   PositionPanel.add(mip);
   PositionPanel.add(mop);
   
   //add statusLabel, StatusPane, exPane and  Position Panel to main panel

   add(StatusLabel);
   add(StatusPane);
   add(exPane);
   add(PositionPanel);    

  }
  

 void UpdatePanel()
  {
  // remove all stuff from main panel
   removeAll();
   
 // get the updated data  
   NewTotalInputs = ip.getInputNumbers();
   NewTotalOutputs = op.getOutputNumbers();
   InputNames = ip.getInputNames();
   OutputNames = op.getOutputNames();
  
  // set the tabular content in the status pane 
   data = new Object[NewTotalInputs+NewTotalOutputs][5];
   for(int i=0; i<NewTotalInputs;i++)
    { 
      data[i][0] = new Integer(i+1);
      data[i][1] = InputNames.elementAt(i);
      data[i][2] = (Object)ip.getDataType_asStr(i);
      data[i][3] = ip.getObjectType_asStr(i);
      data[i][4] = ip.getDescription(i);
     }
  
  for(int i=NewTotalInputs; i<NewTotalInputs+NewTotalOutputs;i++)
    { 
      data[i][0] = new Integer(i+1);
      data[i][1] = OutputNames.elementAt(i-NewTotalInputs);
      data[i][2] = op.getDataType_asStr(i-NewTotalInputs);
      data[i][3] = op.getObjectType_asStr(i-NewTotalInputs);
      data[i][4] = op.getDescription(i-NewTotalInputs);
     }
  
   table = new JTable(data,columnNames);
  //   table.setCellSelectionEnabled(false);
   //System.out.println("Table edi  " + table.setEditable());
    table.setEnabled(false); 
    table.setRowHeight(20);
    table.setFont(new Font("Serif",Font.BOLD,12));

   //table.setPreferredScrollableViewportSize(new Dimension(770, 400));
   StatusPane = new JScrollPane(table);
   StatusPane.setMaximumSize(new Dimension(770,400));
   StatusPane.setSize(StatusPane.getMaximumSize());
   StatusPane.setPreferredSize(new Dimension(770,400));

   // Initialize the exArea and exPane
   exArea.setMaximumSize(new Dimension(770,100));
   exPane.setMaximumSize(new Dimension(770,100));
   exArea.setSize(exArea.getMaximumSize());
   exPane.setPreferredSize(new Dimension(770,100));

PositionPanel.setPreferredSize(new Dimension(770,480));
PositionPanel.setSize(new Dimension(770,480));
PositionPanel.setMinimumSize(new Dimension(770,480));
PositionPanel.setMaximumSize(new Dimension(770,480));

  /*System.out.println("PP "+ PositionPanel.getSize());
   System.out.println("PP max "+ PositionPanel.getMaximumSize());
   System.out.println("PP min "+ PositionPanel.getMinimumSize());
   System.out.println("PP per "+ PositionPanel.getPreferredSize());
*/

   //now add the updated stuff to the main panel

   add(StatusLabel);
   add(StatusPane);
   add(exPane);
   add(PositionPanel);    
  
  // update the sequences in mip & mop in PositionPanel  
   mipUpdatePanel();
   mopUpdatePanel();
 }  // end of main Update



 private void mopUpdatePanel()
 {
   
   if(NewTotalOutputs == 0)
     return;

  if(NewTotalOutputs < 20)
    cl = new CustomLayout(new Dimension(2, 20));  // 10 just to have proper grid size
  else
   cl = new CustomLayout(new Dimension(2, NewTotalOutputs));  // else # of inputs to have grid size

   if(!mopUpdateCalled)  // means update is not called again
    mop.setLayout(cl); // if called then dont setLayout
 
   String[] Sequencestr = new String[NewTotalOutputs];

   if(TotalOutputs == NewTotalOutputs)  // name might differ so check
    mopcheckNames();
   if(TotalOutputs > NewTotalOutputs)
   {
    mop.removeAll();
    TotalOutputs = 0;
    }

    for(int i =0;i<NewTotalOutputs;i++)
      Sequencestr[i] = new Integer(i+1).toString();

   String str;

    for(int i =TotalOutputs;i < NewTotalOutputs;i++)
    {

     str = (i+1) +  "\t"  +(String)OutputNames.elementAt(i);

     mopNameLabels.addElement(new JLabel(str));
     mop.add((JLabel)mopNameLabels.elementAt(i),new Rectangle(0,i,1,1));

      mopSequenceCBox.addElement(new JComboBox(Sequencestr));
      mop.add((JComboBox)mopSequenceCBox.elementAt(i),new Rectangle(1,i,1,1));
      ((JComboBox)mopSequenceCBox.elementAt(i)).addActionListener(this);
      
    ((JComboBox)mopSequenceCBox.elementAt(i)).setSelectedIndex(i);
    
  
    }
  
  if(TotalOutputs != 0)
  {
   for(int i = 0;i<TotalOutputs;i++)
    for(int j = TotalOutputs;j<NewTotalOutputs;j++)
     ((JComboBox)mopSequenceCBox.elementAt(i)).addItem(new Integer(j+1).toString());
   }
 else // ie the user has deleted one or more Outputs in descr panel
   {
   for(int i = 0;i<NewTotalOutputs;i++)
   {
   int count = ((JComboBox)mopSequenceCBox.elementAt(i)).getItemCount();
    for(int j = NewTotalOutputs; j<count;j++)
      ((JComboBox)mopSequenceCBox.elementAt(i)).removeItemAt(NewTotalOutputs);
   }

  }

   int flag = TotalOutputs;
   TotalOutputs = NewTotalOutputs;

   if(NewTotalOutputs > flag)
   {
     mopUpdateCalled = true; // just a flag to check if update is called or not
     UpdatePanel();
   }
 }  // end of mopUpdatePanel()

private void mipUpdatePanel()
 {

   if(NewTotalInputs == 0)
    return;

   if(NewTotalInputs < 20)
    cl = new CustomLayout(new Dimension(2, 20));  // 20 just to have proper grid size
   else
    cl = new CustomLayout(new Dimension(2, NewTotalInputs));  // else # of inputs to have grid size

   if(!mipUpdateCalled)  // means update is not called again
    mip.setLayout(cl); // if called then dont setLayout


   String[]  Sequencestr = new String[NewTotalInputs];


  if(TotalInputs == NewTotalInputs)  // name might differ so check
    mipcheckNames();
  if(TotalInputs > NewTotalInputs)
  {
   mip.removeAll();
   TotalInputs = 0;
   }


   for(int i =0;i<NewTotalInputs;i++)
      Sequencestr[i] = new Integer(i+1).toString();

   String str;

    for(int i =TotalInputs;i<NewTotalInputs;i++)
    {

     str = (i+1) +  "\t"  +(String)InputNames.elementAt(i);

     mipNameLabels.addElement(new JLabel(str));
     mip.add((JLabel)mipNameLabels.elementAt(i),new Rectangle(0,i,1,1));


     mipSequenceCBox.addElement(new JComboBox(Sequencestr));
     mip.add((JComboBox)mipSequenceCBox.elementAt(i),new Rectangle(1,i,1,1));  
      ((JComboBox)mipSequenceCBox.elementAt(i)).addActionListener(this);
    ((JComboBox)mipSequenceCBox.elementAt(i)).setSelectedIndex(i);
    }

  if(TotalInputs != 0)  
  {
   for(int i = 0;i<TotalInputs;i++)
    for(int j = TotalInputs;j<NewTotalInputs;j++)
     ((JComboBox)mipSequenceCBox.elementAt(i)).addItem(new Integer(j+1).toString());
   }
   else // ie the user has deleted one or more inputs in descr panel
   {
    
   for(int i = 0;i<NewTotalInputs;i++)
   {
   int count = ((JComboBox)mipSequenceCBox.elementAt(i)).getItemCount();
    for(int j = NewTotalInputs; j<count;j++)
      ((JComboBox)mipSequenceCBox.elementAt(i)).removeItemAt(NewTotalInputs);
     }

    } 
 
   int flag = TotalInputs;
   TotalInputs = NewTotalInputs;
  TotalInputs = NewTotalInputs;

   if(NewTotalInputs > flag)
   {
     mipUpdateCalled = true; // just a flag to check if update is called or not
     UpdatePanel();
   }

 } // end of mipUpdatePanel

void mipcheckNames()
  {
   String str;

   for(int i = 0; i< NewTotalInputs;i++)  // could have used TotalInputs also
    {
     str = (i+1) +  "   "  +(String)InputNames.elementAt(i);
      ((JLabel)mipNameLabels.elementAt(i)).setText(str);
     }
   }
 void mopcheckNames()
  {
   String str;

   for(int i = 0; i< NewTotalOutputs;i++)  // could have used TotalOutputs also
    {
     str = (i+1) +  "   "  +(String)OutputNames.elementAt(i);
      ((JLabel)mopNameLabels.elementAt(i)).setText(str);
     }
   }

 public void actionPerformed(ActionEvent ae)
 {
 //System.out.println(ae.getSource());
 }




  IOSequence getInputObjectSequence()
  {
 IOSequence ios = new IOSequence(TotalInputs);
  
 try{
       for(int i=0;i<TotalInputs;i++)
     ios.setElementAt(mipgetSelection(i),i);
     }
   catch (ArrayIndexOutOfBoundsException ae)
    {
   
     System.out.println("ArrayIndexOutOfBoundsException has occured\n");
    }
   
    return ios;

  }

 // n is the no. of input for which selection is sort after

  int mipgetSelection(int n)
  {
   int Index = 0;
   Index = Integer.valueOf((String)(((JComboBox)mipSequenceCBox.elementAt(n)).getSelectedItem())).intValue();
   return Index;
  }



  void setInputObjectSequence(IOSequence ios)
  {
 try{
  for (int i = 0;i<ios.getSize();i++)
  {
   ((JComboBox)mipSequenceCBox.elementAt(i)).setSelectedIndex(ios.getElementAt(i) -1);
  }
 }catch(ArrayIndexOutOfBoundsException ae)
  {
  System.out.println("ArrayIndexOutOfBoundsException Has Occured in setInputObjectSequence\n");

  }

  }
   

  IOSequence getOutputObjectSequence()
  {
  IOSequence ios = new IOSequence(TotalOutputs);

 try{
       for(int i=0;i<TotalOutputs;i++)
     ios.setElementAt(mopgetSelection(i),i);
     }
   catch (ArrayIndexOutOfBoundsException ae)
    {
     System.out.println("ArrayIndexOutOfBoundsException has occured\n");
    }

    return ios;

  }

// n is the no. of input for which selection is sort after

  int mopgetSelection(int n)
  {
   int Index = 0;
   Index = Integer.valueOf((String)(((JComboBox)mopSequenceCBox.elementAt(n)).getSelectedItem())).intValue();
   return Index;
  }





  void setOutputObjectSequence(IOSequence  oos)
  {
 try{
      for (int i = 0;i<oos.getSize();i++)
       ((JComboBox)mopSequenceCBox.elementAt(i)).setSelectedIndex(oos.getElementAt(i) -1);
   }
 catch(ArrayIndexOutOfBoundsException ae)
  {
  System.out.println("ArrayIndexOutOfBoundsException Has Occured in setOutputObjectSequence \n");

  }


  }


} // end of MCallingSequencePanel Class


