import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Vector;
//import com.util.myjava.*;  // to import CustomLayout, MovingCanvas, ColorChooser

public class MCSOutputPanel extends JPanel
{
 private JLabel TitleLabel;
 OutputPanel op = null;
 private int TotalOutputs;
 private int NewTotalOutputs;
 

 private java.util.Vector OutputNames;


 java.util.Vector NameLabels;  // just Name and Number
 java.util.Vector SequenceCBox; // Just the Sequence


 private JPanel OutputDetailsPanel;
  CustomLayout cl = null;
 boolean UpdateCalled = false;



 public MCSOutputPanel(OutputPanel op)
  {
   this.op = op;
 
   TitleLabel = new JLabel();
   OutputNames = new java.util.Vector();
 
   NameLabels = new java.util.Vector();
   SequenceCBox = new java.util.Vector();
   
   OutputDetailsPanel = new JPanel();

    this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
  
   add(TitleLabel);  // shows Ori Pos ,Output Name and New Position
   add(new JLabel(" "));
   add(OutputDetailsPanel);  // panel thats going to hold stuff


   TitleLabel.setText("Original Positon \t Output Name\t New Postion");
   OutputDetailsPanel.setLayout(new GridLayout(TotalOutputs,2));
   OutputDetailsPanel.setPreferredSize(new Dimension(100,50));

   } // end of MCSOutputPanel() Constructor

  void UpdatePanel()
  {
  
   NewTotalOutputs = op.getOutputNumbers(); 
   if(NewTotalOutputs == 0)
     return;

   OutputNames = op.getOutputNames();
 

  if(NewTotalOutputs < 20)
     cl = new CustomLayout(new Dimension(2, 20));  // 10 just to have proper grid size
   else
     cl = new CustomLayout(new Dimension(2, NewTotalOutputs));  // else # of inputs to have grid size

   if(!UpdateCalled)  // means update is not called again
    OutputDetailsPanel.setLayout(cl); // if called then dont setLayout


  
   String[] Sequencestr = new String[NewTotalOutputs];

   if(TotalOutputs == NewTotalOutputs)  // name might differ so check
    checkNames();
  if(TotalOutputs > NewTotalOutputs)
  {
   OutputDetailsPanel.removeAll();
   TotalOutputs = 0;
   }

    for(int i =0;i<NewTotalOutputs;i++)
      Sequencestr[i] = new Integer(i+1).toString();

   String str;

    for(int i =TotalOutputs;i < NewTotalOutputs;i++)
    {

     str = (i+1) +  "\t"  +(String)OutputNames.elementAt(i);

     NameLabels.addElement(new JLabel(str));
     OutputDetailsPanel.add((JLabel)NameLabels.elementAt(i),new Rectangle(0,i,1,1));

      SequenceCBox.addElement(new JComboBox(Sequencestr));
      OutputDetailsPanel.add((JComboBox)SequenceCBox.elementAt(i),new Rectangle(1,i,1,1));
    }

   for(int i = 0;i<TotalOutputs;i++)
    for(int j = TotalOutputs;j<NewTotalOutputs;j++)
     ((JComboBox)SequenceCBox.elementAt(i)).addItem(new Integer(j+1).toString());


   int flag = TotalOutputs;
   TotalOutputs = NewTotalOutputs;
   
   if(NewTotalOutputs > flag)
   {
     UpdateCalled = true; // just a flag to check if update is called or not
     UpdatePanel();
   }
 }  // end of UpdatePanel()



  void checkNames()
  {
   String str;

   for(int i = 0; i< NewTotalOutputs;i++)  // could have used TotalOutputs also
    {
     str = (i+1) +  "   "  +(String)OutputNames.elementAt(i);
      ((JLabel)NameLabels.elementAt(i)).setText(str);
     }
   }
















IOSequence  getOutputObjectSequence()
 {
   IOSequence ios = new IOSequence(TotalOutputs);

 try{
       for(int i=0;i<TotalOutputs;i++)
     ios.setElementAt(getSelection(i),i);
     }
   catch (ArrayIndexOutOfBoundsException ae)
    {
     System.out.println("ArrayIndexOutOfBoundsException has occured\n");
    }

    return ios;
  }

// n is the no. of input for which selection is sort after

  int getSelection(int n)
  {
   int Index = 0;
   Index = Integer.valueOf((String)(((JComboBox)SequenceCBox.elementAt(n)).getSelectedItem())).intValue();
   return Index;
  }

 void setOutputObjectSequence(IOSequence oos)
  {
  try{
      for (int i = 0;i<oos.getSize();i++)
       ((JComboBox)SequenceCBox.elementAt(i)).setSelectedIndex(oos.getElementAt(i) -1);
   }
 catch(ArrayIndexOutOfBoundsException ae)
  {
  System.out.println("ArrayIndexOutOfBoundsException Has Occured in setOutputObjectSequence \n");

  }

 }



} // end of MCSOutputPanel Class

