/*
 *
 * @version 1.1, 26 Jan 1998
 * @author Henri Casanova (casanova@cs.utk.edu)
 *
 **/

public class LinkedList{

  Object content;
  LinkedList next;
  
  public LinkedList() {
    content = null;
    next = null;
  }

  public LinkedList(Object item) {
    content = item;
    next = null;
  }

   public Object pop() {
      Object out;
      
      out = this.content;
      if (this.next != null) { 
         this.content = this.next.content;
         this.next = this.next.next;
      } else {
         this.content = null;
      }
    
      return out;
   }

  public void insert(Object item) {
    if (content == null) {
      content = item;  
    }
    else { /* Travel to the end */
      LinkedList tmp = this;

      while (tmp.next != null)
        tmp = tmp.next;
      tmp.next = new LinkedList(item);
    }
  }

  public void clear() {
    if (this.next != null)
    {
      this.next.destroy();
      this.next = null;
    }
    if (this.content != null)
      this.content = null;
  }

  public void destroy() {
    this.content = null;
    if (this.next != null)
      this.next.destroy();
  }
  
  public int length() {
    if (this.next != null)
      return 1 + this.next.length();
    else if (this.content != null)
      return 1;
    else
      return 0;
  }

  public java.util.Enumeration names()
  {
   java.util.Vector names = new java.util.Vector();
   int length = length();
  
  for(int i =0;i<length;i++)
   {  
      names.addElement(pop());
      
   } 
  
   return names.elements() ;
  }
}
